/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import io.contek.tusk.MetricClient;
import io.contek.tusk.Schema;
import io.contek.tusk.Table;
import io.contek.tusk.Tusk;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SchemaProvider {
    private final Table table;
    private final AtomicReference<Schema> cache = new AtomicReference<Object>(null);

    public SchemaProvider(Table table) {
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Schema getSchema() {
        AtomicReference<Schema> atomicReference = this.cache;
        synchronized (atomicReference) {
            return this.cache.updateAndGet(oldValue -> {
                if (oldValue != null) {
                    return oldValue;
                }
                return SchemaProvider.fetch(this.table);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clear() {
        AtomicReference<Schema> atomicReference = this.cache;
        synchronized (atomicReference) {
            return this.cache.getAndSet(null) != null;
        }
    }

    @Nullable
    private static Schema fetch(Table table) {
        MetricClient client = Tusk.getClient();
        if (client == null) {
            return null;
        }
        return client.describe(table);
    }
}

