/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import io.contek.tusk.BatchingConfig;
import io.contek.tusk.Metric;
import io.contek.tusk.MetricData;
import io.contek.tusk.MetricFormatter;
import io.contek.tusk.MetricRow;
import io.contek.tusk.Table;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class MetricBatch {
    private static final Logger LOGGER = Logger.getLogger(Metric.class.getName());
    private final Table table;
    private final BatchingConfig config;
    private final List<MetricRow> rows = new ArrayList<MetricRow>();
    private final AtomicInteger dropCount = new AtomicInteger(0);

    MetricBatch(Table table, BatchingConfig config) {
        this.table = table;
        this.config = config;
    }

    boolean isImmediate() {
        return this.getPeriod().isZero();
    }

    Duration getPeriod() {
        return this.config.getPeriod();
    }

    synchronized void add(MetricRow row) {
        Integer maxSize = this.config.getMaxSize();
        if (maxSize != null && this.rows.size() >= maxSize) {
            this.dropCount.incrementAndGet();
        } else {
            this.rows.add(row);
        }
    }

    @Nullable
    synchronized MetricData export(MetricFormatter formatter) {
        MetricData data = formatter.format(this.rows);
        this.rows.clear();
        int dropped = this.dropCount.getAndSet(0);
        if (dropped > 0) {
            LOGGER.log(Level.SEVERE, String.format("Dropped %d rows inserting to table %s.", dropped, this.table));
        }
        return data;
    }
}

