package io.contek.tusk;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public final class SchemaProvider {

  private final Table table;
  private final AtomicReference<Schema> cache = new AtomicReference<>(null);

  public SchemaProvider(Table table) {
    this.table = table;
  }

  @Nullable
  public Schema getSchema() {
    synchronized (cache) {
      return cache.updateAndGet(
          oldValue -> {
            if (oldValue != null) {
              return oldValue;
            }

            return fetch(table);
          });
    }
  }

  boolean clear() {
    synchronized (cache) {
      return cache.getAndSet(null) != null;
    }
  }

  @Nullable
  private static Schema fetch(Table table) {
    MetricClient client = Tusk.getClient();
    if (client == null) {
      return null;
    }

    return client.describe(table);
  }
}
