package io.contek.tusk;

import com.clickhouse.data.ClickHouseDataType;

import javax.annotation.concurrent.ThreadSafe;

import static java.lang.String.format;

@ThreadSafe
final class EntryChecker {

  private final SchemaProvider provider;

  EntryChecker(SchemaProvider provider) {
    this.provider = provider;
  }

  void check(String column, ClickHouseDataType type) {
    Schema schema = provider.getSchema();
    if (schema == null) {
      return;
    }

    ClickHouseDataType expected = schema.getColumnType(column);
    if (expected == null) {
      throw new MetricFormatException(format("Column \"%s\" is not defined in the schema", column));
    }

    if (expected != type) {
      throw new MetricFormatException(
          format(
              "Column \"%s\" input type \"%s\" does not match expect type \"%s\"",
              column, type, expected));
    }
  }
}
