package io.contek.tusk;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicReference;

@Immutable
public final class Tusk {

  private static final AtomicReference<MetricClient> clientHolder = new AtomicReference<>(null);
  private static final AtomicReference<Clock> clockHolder =
      new AtomicReference<>(Clock.systemUTC());

  public static void setClient(MetricClient client) {
    clientHolder.set(client);
  }

  public static void setClock(Clock clock) {
    clockHolder.set(clock);
  }

  public static Clock getClock() {
    return clockHolder.get();
  }

  @Nullable
  static MetricClient getClient() {
    return clientHolder.get();
  }

  private Tusk() {}
}
