package io.contek.tusk;

import com.clickhouse.data.ClickHouseDataType;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

import static com.clickhouse.data.ClickHouseDataType.DateTime;
import static com.clickhouse.data.ClickHouseDataType.DateTime64;

@ThreadSafe
final class TimeColumnCache {

  private final Table table;
  private final SchemaProvider provider;
  private final AtomicReference<String> cache = new AtomicReference<>(null);

  TimeColumnCache(Table table, SchemaProvider provider) {
    this.table = table;
    this.provider = provider;
  }

  @Nullable
  String get() {
    return cache.updateAndGet(
        oldValue -> {
          if (oldValue != null) {
            return oldValue;
          }

          if (table.getTimeColumn() != null) {
            return table.getTimeColumn();
          }

          Schema schema = provider.getSchema();
          if (schema == null) {
            return null;
          }

          return getFirstDateTimeColumn(schema);
        });
  }

  void clear() {
    cache.set(null);
  }

  @Nullable
  private static String getFirstDateTimeColumn(Schema schema) {
    for (Map.Entry<String, ClickHouseDataType> entry : schema.getColumns().entrySet()) {
      ClickHouseDataType type = entry.getValue();
      if (type == DateTime || type == DateTime64) {
        return entry.getKey();
      }
    }

    return null;
  }
}
