package io.contek.tusk;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

import static java.lang.String.format;
import static java.util.logging.Level.SEVERE;
import static java.util.logging.Logger.getLogger;

@ThreadSafe
final class MetricBatch {

  private static final Logger LOGGER = getLogger(Metric.class.getName());

  private final Table table;
  private final BatchingConfig config;
  private final List<MetricRow> rows = new ArrayList<>();
  private final AtomicInteger dropCount = new AtomicInteger(0);

  MetricBatch(Table table, BatchingConfig config) {
    this.table = table;
    this.config = config;
  }

  boolean isImmediate() {
    return getPeriod().isZero();
  }

  Duration getPeriod() {
    return config.getPeriod();
  }

  synchronized void add(MetricRow row) {
    Integer maxSize = config.getMaxSize();
    if (maxSize != null && rows.size() >= maxSize) {
      dropCount.incrementAndGet();
    } else {
      rows.add(row);
    }
  }

  @Nullable
  synchronized MetricData export(MetricFormatter formatter) {
    MetricData data = formatter.format(rows);

    rows.clear();
    int dropped = dropCount.getAndSet(0);
    if (dropped > 0) {
      LOGGER.log(SEVERE, format("Dropped %d rows inserting to table %s.", dropped, table));
    }
    return data;
  }
}
