/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseRecord;
import io.contek.tusk.MetricData;
import io.contek.tusk.Schema;
import io.contek.tusk.Table;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetricClient {
    private static final Logger LOGGER = Logger.getLogger(MetricClient.class.getName());
    private final ClickHouseClient client;
    private final ClickHouseNode server;

    private MetricClient(ClickHouseClient client, ClickHouseNode server) {
        this.client = client;
        this.server = server;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    Schema describe(Table table) {
        try {
            String query = String.format("DESCRIBE TABLE %s", table.getName());
            ClickHouseResponse response = (ClickHouseResponse)this.newRequest(table.getDatabase()).format(ClickHouseFormat.TabSeparatedWithNamesAndTypes).query(query).execute().get();
            Iterable records = response.records();
            Schema.Builder result = Schema.newBuilder();
            for (ClickHouseRecord record : records) {
                String columnName = record.getValue("name").asString();
                String columnType = record.getValue("type").asString();
                ClickHouseDataType type = MetricClient.parseType(columnType);
                result.add(columnName, type);
            }
            return result.build();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, String.format("Failed to describe table %s.", table), t);
            return null;
        }
    }

    void write(MetricData data, Consumer<Throwable> onError) {
        ((ClickHouseRequest.Mutation)this.newRequest(data.getTable().getDatabase()).write().table(data.getTable().getName())).format(data.getFormat()).data(data.getInputStream()).seal().execute().exceptionally(t -> {
            LOGGER.log(Level.SEVERE, String.format("Failed to write data into table %s.", data.getTable()), (Throwable)t);
            onError.accept((Throwable)t);
            return null;
        });
    }

    private ClickHouseRequest<?> newRequest(@Nullable String database) {
        ClickHouseRequest request = this.client.read(this.server);
        if (database != null) {
            request.use(database);
        }
        return request;
    }

    private static ClickHouseDataType parseType(String typeName) {
        String typeNameOrModifier;
        if (!typeName.endsWith(")")) {
            return ClickHouseDataType.of((String)typeName);
        }
        int bracketIndex = typeName.indexOf(40);
        return switch (typeNameOrModifier = typeName.substring(0, bracketIndex)) {
            case "LowCardinality", "Nullable" -> ClickHouseDataType.of((String)typeName.substring(bracketIndex + 1, typeName.length() - 1));
            default -> ClickHouseDataType.of((String)typeNameOrModifier);
        };
    }

    @NotThreadSafe
    public static final class Builder {
        private String host = "localhost";
        private String user = "default";
        private Duration connectTimeout = Duration.ofSeconds(60L);
        private Duration socketTimeout = Duration.ofSeconds(180L);
        private String password;
        private String database;
        private Integer port = 8123;
        private boolean secure = false;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder setSecure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setPassword(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder setDatabase(@Nullable String database) {
            this.database = database;
            return this;
        }

        public MetricClient build() {
            Objects.requireNonNull(this.connectTimeout);
            ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of((ClickHouseProtocol)ClickHouseProtocol.HTTP, (ClickHouseProtocol[])new ClickHouseProtocol[0])).option((ClickHouseOption)ClickHouseClientOption.CONNECTION_TIMEOUT, (Serializable)Integer.valueOf((int)this.connectTimeout.toMillis())).option((ClickHouseOption)ClickHouseClientOption.SOCKET_TIMEOUT, (Serializable)Integer.valueOf((int)this.socketTimeout.toMillis())).option((ClickHouseOption)ClickHouseClientOption.COMPRESS_ALGORITHM, (Serializable)ClickHouseCompression.ZSTD).build();
            ClickHouseNode server = this.createConnection();
            return new MetricClient(client, server);
        }

        private ClickHouseNode createConnection() {
            Objects.requireNonNull(this.host);
            Objects.requireNonNull(this.user);
            return ClickHouseNode.builder().host(this.host).database(this.database).credentials(ClickHouseCredentials.fromUserAndPassword((String)this.user, (String)this.password)).port(ClickHouseProtocol.HTTP, this.port).addOption("ssl", this.secure ? "true" : "false").build();
        }

        private Builder() {
        }
    }
}

