/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import com.clickhouse.data.ClickHouseDataType;
import com.google.common.collect.ImmutableMap;
import io.contek.tusk.Schema;
import io.contek.tusk.SchemaProvider;
import io.contek.tusk.TuskUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class EnvTagsCache {
    private final SchemaProvider provider;
    private final AtomicReference<ImmutableMap<String, String>> cache = new AtomicReference<Object>(null);

    EnvTagsCache(SchemaProvider provider) {
        this.provider = provider;
    }

    @Nullable
    ImmutableMap<String, String> get() {
        return this.cache.updateAndGet(oldValue -> {
            if (oldValue != null) {
                return oldValue;
            }
            Schema schema = this.provider.getSchema();
            if (schema == null) {
                return null;
            }
            return EnvTagsCache.getTagsFromEnv(schema);
        });
    }

    void clear() {
        this.cache.set(null);
    }

    private static ImmutableMap<String, String> getTagsFromEnv(Schema schema) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : schema.getColumns().entrySet()) {
            String key;
            String value;
            if (entry.getValue() != ClickHouseDataType.String || (value = TuskUtils.getEnvTag(key = (String)entry.getKey())) == null) continue;
            result.put((Object)key, (Object)value);
        }
        return result.build();
    }
}

