/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TuskUtils {
    public static String getAppName(String appColumn) {
        String appEnvTag = TuskUtils.getEnvTag(appColumn);
        if (appEnvTag != null) {
            return appEnvTag;
        }
        return TuskUtils.getMainClassName();
    }

    @Nullable
    public static String getEnvTag(String key) {
        String value = System.getenv(key);
        if (value == null) {
            value = System.getenv(key.toLowerCase());
        }
        if (value == null) {
            value = System.getenv(key.toUpperCase());
        }
        return value;
    }

    private static String getMainClassName() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length < 1) {
            return "";
        }
        String mainClassName = trace[trace.length - 1].getClassName();
        int lastIndex = mainClassName.lastIndexOf(".");
        return mainClassName.substring(lastIndex + 1);
    }

    private TuskUtils() {
    }
}

