/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import com.clickhouse.client.ClickHouseDataType;
import io.contek.tusk.Schema;
import io.contek.tusk.SchemaProvider;
import io.contek.tusk.Table;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TimeColumnCache {
    private final Table table;
    private final SchemaProvider provider;
    private final AtomicReference<String> cache = new AtomicReference<Object>(null);

    TimeColumnCache(Table table, SchemaProvider provider) {
        this.table = table;
        this.provider = provider;
    }

    @Nullable
    String get() {
        return this.cache.updateAndGet(oldValue -> {
            if (oldValue != null) {
                return oldValue;
            }
            if (this.table.getTimeColumn() != null) {
                return this.table.getTimeColumn();
            }
            Schema schema = this.provider.getSchema();
            if (schema == null) {
                return null;
            }
            return TimeColumnCache.getFirstDateTimeColumn(schema);
        });
    }

    void clear() {
        this.cache.set(null);
    }

    @Nullable
    private static String getFirstDateTimeColumn(Schema schema) {
        for (Map.Entry entry : schema.getColumns().entrySet()) {
            ClickHouseDataType type = (ClickHouseDataType)entry.getValue();
            if (type != ClickHouseDataType.DateTime && type != ClickHouseDataType.DateTime64) continue;
            return (String)entry.getKey();
        }
        return null;
    }
}

