/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import com.clickhouse.client.ClickHouseDataType;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import io.contek.tusk.BatchingConfig;
import io.contek.tusk.EntryChecker;
import io.contek.tusk.EnvTagsCache;
import io.contek.tusk.MetricBatch;
import io.contek.tusk.MetricClient;
import io.contek.tusk.MetricData;
import io.contek.tusk.MetricFormatter;
import io.contek.tusk.MetricRow;
import io.contek.tusk.SchemaProvider;
import io.contek.tusk.Table;
import io.contek.tusk.TimeColumnCache;
import io.contek.tusk.Tusk;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class Metric {
    private static final Logger LOGGER = Logger.getLogger(Metric.class.getName());
    private final Table table;
    private final SchemaProvider schema;
    private final TimeColumnCache timeColumn;
    private final EnvTagsCache envTags;
    private final EntryChecker checker;
    private final MetricFormatter formatter;
    private final MetricBatch batch;
    private final AtomicReference<Future<?>> task = new AtomicReference<Object>(null);
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    private Metric(Table table, SchemaProvider schema, TimeColumnCache timeColumn, EnvTagsCache envTags, EntryChecker checker, MetricFormatter formatter, BatchingConfig batching) {
        this.table = table;
        this.schema = schema;
        this.timeColumn = timeColumn;
        this.envTags = envTags;
        this.checker = checker;
        this.formatter = formatter;
        this.batch = new MetricBatch(table, batching);
    }

    public static Metric metric(String table) {
        return Metric.metric(null, table);
    }

    public static Metric metric(@Nullable String database, String table) {
        return Metric.metric(Table.newBuilder().setDatabase(database).setName(table).build());
    }

    public static Metric metric(Table table) {
        return Metric.metric(table, BatchingConfig.getDefault());
    }

    public static Metric metric(Table.Builder table, BatchingConfig batching) {
        return Metric.metric(table.build(), batching);
    }

    public static Metric metric(Table table, BatchingConfig batching) {
        SchemaProvider schema = new SchemaProvider(table);
        return new Metric(table, schema, new TimeColumnCache(table, schema), new EnvTagsCache(schema), new EntryChecker(schema), new MetricFormatter(table, schema), batching);
    }

    public EntryWriter newEntry() {
        return new EntryWriter(this::insert, this.timeColumn, this.envTags, this.checker);
    }

    private void insert(MetricRow row) {
        this.batch.add(row);
        this.scheduleIfIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIfIdle() {
        if (this.batch.isImmediate()) {
            this.flush();
            return;
        }
        AtomicReference<Future<?>> atomicReference = this.task;
        synchronized (atomicReference) {
            Future<?> future = this.task.get();
            if (future != null && !future.isDone()) {
                return;
            }
            this.schedule();
        }
    }

    private void flushAndSchedule() {
        boolean updated = this.flush();
        if (!updated) {
            return;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        AtomicReference<Future<?>> atomicReference = this.task;
        synchronized (atomicReference) {
            ScheduledFuture<?> future = this.scheduler.schedule(this::flushAndSchedule, this.batch.getPeriod().getSeconds(), TimeUnit.SECONDS);
            this.task.set(future);
        }
    }

    private boolean flush() {
        MetricData data;
        MetricClient client = Tusk.getClient();
        if (client == null) {
            return false;
        }
        try {
            data = this.batch.export(this.formatter);
            if (data == null) {
                return false;
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to format metric data.", e);
            return false;
        }
        client.write(data, this::onWriteError);
        return true;
    }

    private void onWriteError(Throwable t) {
        if (t instanceof CompletionException) {
            t = t.getCause();
        }
        if (t instanceof ClickHouseException) {
            this.onClientError((ClickHouseException)t);
        }
    }

    private void onClientError(ClickHouseException e) {
        switch (e.getErrorCode()) {
            case 33: 
            case 60: {
                this.clearSchema();
            }
        }
    }

    private void clearSchema() {
        if (this.schema.clear()) {
            this.timeColumn.clear();
            this.envTags.clear();
            LOGGER.log(Level.INFO, String.format("Schema cache for %s is evicted.", this.table));
        }
    }

    @NotThreadSafe
    public static final class EntryWriter {
        private final Consumer<MetricRow> consumer;
        private final TimeColumnCache timeColumnCache;
        private final EnvTagsCache envTagsCache;
        private final EntryChecker checker;
        private final Map<String, Object> keyValues = new HashMap<String, Object>();

        public EntryWriter putBoolean(String key, boolean value) {
            this.checker.check(key, ClickHouseDataType.Bool);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putInt8(String key, byte value) {
            this.checker.check(key, ClickHouseDataType.Int8);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putInt16(String key, long value) {
            return this.putInt16(key, Shorts.checkedCast((long)value));
        }

        public EntryWriter putInt16(String key, short value) {
            this.checker.check(key, ClickHouseDataType.Int16);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putInt32(String key, long value) {
            return this.putInt32(key, Ints.checkedCast((long)value));
        }

        public EntryWriter putInt32(String key, int value) {
            this.checker.check(key, ClickHouseDataType.Int32);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putInt64(String key, long value) {
            this.checker.check(key, ClickHouseDataType.Int64);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putUInt8(String key, boolean bool) {
            int unsignedByte = bool ? 1 : 0;
            return this.putUInt8(key, unsignedByte);
        }

        public EntryWriter putUInt8(String key, byte signedByte) {
            int unsignedByte = signedByte & 0xFF;
            return this.putUInt8(key, unsignedByte);
        }

        public EntryWriter putUInt8(String key, int value) {
            if (value > 255) {
                throw new IllegalArgumentException(key + ": " + value + " > 255");
            }
            this.checker.check(key, ClickHouseDataType.UInt8);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putUInt16(String key, short signedShort) {
            int unsignedShort = signedShort & 0xFFFF;
            return this.putUInt16(key, unsignedShort);
        }

        public EntryWriter putUInt16(String key, long value) {
            return this.putUInt16(key, Ints.checkedCast((long)value));
        }

        public EntryWriter putUInt16(String key, int value) {
            if (value > 65535) {
                throw new IllegalArgumentException(key + ": " + value + " > 65535");
            }
            this.checker.check(key, ClickHouseDataType.UInt16);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putUInt32(String key, int value) {
            long unsignedInt = (long)value & 0xFFFFFFFFL;
            return this.putUInt32(key, unsignedInt);
        }

        public EntryWriter putUInt32(String key, long value) {
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(key + ": " + value + " > 4294967295");
            }
            this.checker.check(key, ClickHouseDataType.UInt32);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putUInt64(String key, long value) {
            return this.putUInt64(key, BigInteger.valueOf(value));
        }

        public EntryWriter putUInt64(String key, BigInteger value) {
            if (value.compareTo(BinaryStreamUtils.U_INT64_MAX) > 0) {
                throw new IllegalArgumentException(key + ": " + value + " > " + BinaryStreamUtils.U_INT64_MAX);
            }
            this.checker.check(key, ClickHouseDataType.UInt64);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putFloat32(String key, double value) {
            return this.putFloat32(key, (float)value);
        }

        public EntryWriter putFloat32(String key, float value) {
            this.checker.check(key, ClickHouseDataType.Float32);
            this.keyValues.put(key, Float.valueOf(value));
            return this;
        }

        public EntryWriter putFloat64(String key, double value) {
            this.checker.check(key, ClickHouseDataType.Float64);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putString(String key, Enum<?> value) {
            return this.putString(key, value.name());
        }

        public EntryWriter putString(String key, String value) {
            this.checker.check(key, ClickHouseDataType.String);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putDateTime(String key, Instant value) {
            this.checker.check(key, ClickHouseDataType.DateTime);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putDateTime64(String key, Instant value) {
            this.checker.check(key, ClickHouseDataType.DateTime64);
            this.keyValues.put(key, value);
            return this;
        }

        public EntryWriter putAll(Map<String, ?> fields) {
            this.keyValues.putAll(fields);
            return this;
        }

        public void write() {
            ImmutableMap<String, String> tags;
            String timeColumn = this.timeColumnCache.get();
            if (timeColumn != null) {
                this.checker.check(timeColumn, ClickHouseDataType.DateTime64);
                this.keyValues.putIfAbsent(timeColumn, Tusk.getClock().instant());
            }
            if ((tags = this.envTagsCache.get()) != null) {
                tags.forEach(this.keyValues::putIfAbsent);
            }
            this.consumer.accept(new MetricRow(this.keyValues));
        }

        private EntryWriter(Consumer<MetricRow> consumer, TimeColumnCache timeColumnCache, EnvTagsCache envTagsCache, EntryChecker checker) {
            this.consumer = consumer;
            this.timeColumnCache = timeColumnCache;
            this.envTagsCache = envTagsCache;
            this.checker = checker;
        }
    }
}

