/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import com.clickhouse.client.ClickHouseDataType;
import io.contek.tusk.MetricFormatException;
import io.contek.tusk.Schema;
import io.contek.tusk.SchemaProvider;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class EntryChecker {
    private final SchemaProvider provider;

    EntryChecker(SchemaProvider provider) {
        this.provider = provider;
    }

    void check(String column, ClickHouseDataType type) {
        Schema schema = this.provider.getSchema();
        if (schema == null) {
            return;
        }
        ClickHouseDataType expected = schema.getColumnType(column);
        if (expected == null) {
            throw new MetricFormatException(String.format("Column \"%s\" is not defined in the schema", column));
        }
        if (expected != type) {
            throw new MetricFormatException(String.format("Column \"%s\" input type \"%s\" does not match expect type \"%s\"", column, type, expected));
        }
    }
}

