/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import com.clickhouse.client.ClickHouseDataType;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.data.BinaryStreamUtils;
import io.contek.tusk.MetricData;
import io.contek.tusk.MetricFormatException;
import io.contek.tusk.MetricRow;
import io.contek.tusk.Schema;
import io.contek.tusk.SchemaProvider;
import io.contek.tusk.Table;
import io.contek.tusk.Tusk;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class MetricFormatter {
    private final Table table;
    private final SchemaProvider provider;

    MetricFormatter(Table table, SchemaProvider provider) {
        this.table = table;
        this.provider = provider;
    }

    @Nullable
    public MetricData format(List<MetricRow> rows) throws MetricFormatException {
        MetricData metricData;
        Schema schema = this.provider.getSchema();
        if (schema == null || rows.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            for (MetricRow row : rows) {
                schema.getColumns().forEach(MetricFormatter.findAndWriteValue(row, output));
            }
            metricData = new MetricData(this.table, output.toByteArray(), ClickHouseFormat.RowBinary);
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MetricFormatException(e);
            }
        }
        output.close();
        return metricData;
    }

    private static BiConsumer<String, ClickHouseDataType> findAndWriteValue(MetricRow row, OutputStream output) {
        return (column, type) -> {
            Object value = row.getValue((String)column);
            MetricFormatter.writeValue(value, type, output);
        };
    }

    private static void writeValue(@Nullable Object value, ClickHouseDataType type, OutputStream output) {
        try {
            switch (type) {
                case DateTime: {
                    Instant instant = value == null ? Instant.EPOCH : (Instant)value;
                    ZoneId tz = Tusk.getClock().getZone();
                    BinaryStreamUtils.writeDateTime((OutputStream)output, (LocalDateTime)LocalDateTime.ofInstant(instant, tz), (TimeZone)TimeZone.getTimeZone(tz));
                    break;
                }
                case DateTime64: {
                    Instant instant = value == null ? Instant.EPOCH : (Instant)value;
                    ZoneId tz = Tusk.getClock().getZone();
                    BinaryStreamUtils.writeDateTime64((OutputStream)output, (LocalDateTime)LocalDateTime.ofInstant(instant, tz), (TimeZone)TimeZone.getTimeZone(tz));
                    break;
                }
                case String: {
                    String str = value == null ? "" : (String)value;
                    BinaryStreamUtils.writeString((OutputStream)output, (String)str);
                    break;
                }
                case UInt8: {
                    int uInt8 = value == null ? 0 : (Integer)value;
                    BinaryStreamUtils.writeUnsignedInt8((OutputStream)output, (int)uInt8);
                    break;
                }
                case UInt16: {
                    int uInt16 = value == null ? 0 : (Integer)value;
                    BinaryStreamUtils.writeUnsignedInt16((OutputStream)output, (int)uInt16);
                    break;
                }
                case UInt32: {
                    long uInt32 = value == null ? 0L : (Long)value;
                    BinaryStreamUtils.writeUnsignedInt32((OutputStream)output, (long)uInt32);
                    break;
                }
                case UInt64: {
                    BigInteger uInt64 = value == null ? BigInteger.ZERO : (BigInteger)value;
                    BinaryStreamUtils.writeUnsignedInt64((OutputStream)output, (BigInteger)uInt64);
                    break;
                }
                case Int8: {
                    byte int8 = value == null ? (byte)0 : (Byte)value;
                    BinaryStreamUtils.writeInt8((OutputStream)output, (byte)int8);
                    break;
                }
                case Int16: {
                    short int16 = value == null ? (short)0 : (Short)value;
                    BinaryStreamUtils.writeInt16((OutputStream)output, (short)int16);
                    break;
                }
                case Int32: {
                    int int32 = value == null ? 0 : (Integer)value;
                    BinaryStreamUtils.writeInt32((OutputStream)output, (int)int32);
                    break;
                }
                case Int64: {
                    long int64 = value == null ? 0L : (Long)value;
                    BinaryStreamUtils.writeInt64((OutputStream)output, (long)int64);
                    break;
                }
                case Float32: {
                    float float32 = value == null ? 0.0f : ((Float)value).floatValue();
                    BinaryStreamUtils.writeFloat32((OutputStream)output, (float)float32);
                    break;
                }
                case Float64: {
                    double float64 = value == null ? 0.0 : (Double)value;
                    BinaryStreamUtils.writeFloat64((OutputStream)output, (double)float64);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(type.name());
                }
            }
        }
        catch (Throwable e) {
            throw new MetricFormatException(e);
        }
    }
}

