package io.contek.tusk;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

import static java.util.Objects.requireNonNull;

@Immutable
public final class Table {

  private final String database;
  private final String name;
  private final String timeColumn;
  private String str;

  private Table(@Nullable String database, String name, @Nullable String timeColumn) {
    this.database = database;
    this.name = name;
    this.timeColumn = timeColumn;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  @Nullable
  public String getDatabase() {
    return database;
  }

  public String getName() {
    return name;
  }

  @Nullable
  public String getTimeColumn() {
    return timeColumn;
  }

  @Override
  public String toString() {
    if (str == null) {
      StringBuilder sb = new StringBuilder();
      if (database != null) {
        sb.append(database).append(".");
      }
      sb.append(name);
      if (timeColumn != null) {
        sb.append("(").append(timeColumn).append(")");
      }
      str = sb.toString();
    }
    return str;
  }

  @NotThreadSafe
  public static final class Builder {

    private String database;
    private String name;
    private String timeColumn;

    public Builder setDatabase(@Nullable String database) {
      this.database = database;
      return this;
    }

    public Builder setName(String name) {
      this.name = name;
      return this;
    }

    public Builder setTimeColumn(@Nullable String timeColumn) {
      this.timeColumn = timeColumn;
      return this;
    }

    public Table build() {
      requireNonNull(name);
      return new Table(database, name, timeColumn);
    }

    private Builder() {}
  }
}
