package io.contek.tusk;

import com.clickhouse.client.ClickHouseFormat;

import javax.annotation.concurrent.Immutable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

@Immutable
final class MetricData {

  private final Table table;
  private final byte[] bytes;
  private final ClickHouseFormat format;

  MetricData(Table table, byte[] bytes, ClickHouseFormat format) {
    this.table = table;
    this.bytes = bytes;
    this.format = format;
  }

  Table getTable() {
    return table;
  }

  InputStream getInputStream() {
    return new ByteArrayInputStream(bytes);
  }

  ClickHouseFormat getFormat() {
    return format;
  }
}
