package io.contek.tusk;

import com.clickhouse.client.ClickHouseDataType;
import com.google.common.collect.ImmutableMap;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
final class EnvTagsCache {

  private final SchemaProvider provider;
  private final AtomicReference<ImmutableMap<String, String>> cache = new AtomicReference<>(null);

  EnvTagsCache(SchemaProvider provider) {
    this.provider = provider;
  }

  @Nullable
  ImmutableMap<String, String> get() {
    return cache.updateAndGet(
        oldValue -> {
          if (oldValue != null) {
            return oldValue;
          }

          Schema schema = provider.getSchema();
          if (schema == null) {
            return null;
          }

          return getTagsFromEnv(schema);
        });
  }

  void clear() {
    cache.set(null);
  }

  private static ImmutableMap<String, String> getTagsFromEnv(Schema schema) {
    ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
    for (Map.Entry<String, ClickHouseDataType> entry : schema.getColumns().entrySet()) {
      if (entry.getValue() != ClickHouseDataType.String) {
        continue;
      }

      String key = entry.getKey();
      String value = TuskUtils.getEnvTag(key);

      if (value != null) {
        result.put(key, value);
      }
    }
    return result.build();
  }
}
