/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class Table {
    private final String database;
    private final String name;
    private final String timeColumn;
    private String str;

    private Table(@Nullable String database, String name, @Nullable String timeColumn) {
        this.database = database;
        this.name = name;
        this.timeColumn = timeColumn;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTimeColumn() {
        return this.timeColumn;
    }

    public String toString() {
        if (this.str == null) {
            StringBuilder sb = new StringBuilder();
            if (this.database != null) {
                sb.append(this.database).append(".");
            }
            sb.append(this.name);
            if (this.timeColumn != null) {
                sb.append("(").append(this.timeColumn).append(")");
            }
            this.str = sb.toString();
        }
        return this.str;
    }

    @NotThreadSafe
    public static final class Builder {
        private String database;
        private String name;
        private String timeColumn;

        public Builder setDatabase(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTimeColumn(@Nullable String timeColumn) {
            this.timeColumn = timeColumn;
            return this;
        }

        public Table build() {
            Objects.requireNonNull(this.name);
            return new Table(this.database, this.name, this.timeColumn);
        }

        private Builder() {
        }
    }
}

