/*
 * Decompiled with CFR 0.152.
 */
package io.contek.tusk;

import com.clickhouse.client.ClickHouseDataType;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class Schema {
    private final ImmutableMap<String, ClickHouseDataType> columns;

    private Schema(ImmutableMap<String, ClickHouseDataType> columns) {
        this.columns = columns;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public ClickHouseDataType getColumnType(String columnName) {
        return (ClickHouseDataType)this.columns.get((Object)columnName);
    }

    public ImmutableMap<String, ClickHouseDataType> getColumns() {
        return this.columns;
    }

    @NotThreadSafe
    public static final class Builder {
        private final LinkedHashMap<String, ClickHouseDataType> columns = new LinkedHashMap();

        public Builder addDateTime(String column) {
            return this.add(column, ClickHouseDataType.DateTime64);
        }

        public Builder addString(String column) {
            return this.add(column, ClickHouseDataType.String);
        }

        public Builder addBoolean(String column) {
            return this.add(column, ClickHouseDataType.Bool);
        }

        public Builder addUInt8(String column) {
            return this.add(column, ClickHouseDataType.UInt8);
        }

        public Builder addUInt16(String column) {
            return this.add(column, ClickHouseDataType.UInt16);
        }

        public Builder addUInt32(String column) {
            return this.add(column, ClickHouseDataType.UInt32);
        }

        public Builder addUInt64(String column) {
            return this.add(column, ClickHouseDataType.UInt64);
        }

        public Builder addInt8(String column) {
            return this.add(column, ClickHouseDataType.Int8);
        }

        public Builder addInt16(String column) {
            return this.add(column, ClickHouseDataType.Int16);
        }

        public Builder addInt32(String column) {
            return this.add(column, ClickHouseDataType.Int32);
        }

        public Builder addInt64(String column) {
            return this.add(column, ClickHouseDataType.Int64);
        }

        public Builder addFloat32(String column) {
            return this.add(column, ClickHouseDataType.Float32);
        }

        public Builder addFloat64(String column) {
            return this.add(column, ClickHouseDataType.Float64);
        }

        public Builder add(String column, ClickHouseDataType type) {
            this.columns.put(column, type);
            return this;
        }

        public Schema build() {
            return new Schema(ImmutableMap.copyOf(this.columns));
        }

        private Builder() {
        }
    }
}

