/*
 * Decompiled with CFR 0.152.
 */
package io.confound.config.jndi;

import io.confound.config.AbstractStringConfiguration;
import io.confound.config.ConfigurationException;
import io.confound.config.Section;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class JndiConfiguration
extends AbstractStringConfiguration {
    public static final String JNDI_NAMESPACE = "java:comp/env";
    private final Context context;

    public JndiConfiguration() throws NamingException {
        this(new InitialContext());
    }

    public JndiConfiguration(@Nonnull InitialContext initialContext) throws NamingException {
        this.context = initialContext;
    }

    public Optional<Section> findSection(String key) throws ConfigurationException {
        return Optional.empty();
    }

    protected Optional<String> findConfigurationValueImpl(String key) throws ConfigurationException {
        try {
            return Optional.of(((Context)this.context.lookup(JNDI_NAMESPACE)).lookup(key)).map(Object::toString);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return Optional.empty();
        }
        catch (NamingException namingException) {
            throw new ConfigurationException(String.format("The parameter \"%s\" could not be found on the JNDI context.", key), (Throwable)namingException);
        }
    }
}

