/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String OFFSET = "offset";
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final Pattern LEGAL_TOPIC_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9\\._\\-]+");

    private Utils() {
    }

    public static Map<String, Object> toConnectOffset(long offset) {
        return Collections.singletonMap(OFFSET, offset);
    }

    public static Map<String, ?> toConnectPartition(TopicPartition topicPartition) {
        return Utils.toConnectPartition(topicPartition.topic(), topicPartition.partition());
    }

    public static Map<String, ?> toConnectPartition(String topic, int partition) {
        HashMap<String, Object> connectPartition = new HashMap<String, Object>(2);
        connectPartition.put(TOPIC, topic);
        connectPartition.put(PARTITION, partition);
        return connectPartition;
    }

    public static String renameTopic(String renameFormat, String topic) {
        String renamed = renameFormat.replace("${topic}", topic);
        if (!LEGAL_TOPIC_NAME_PATTERN.matcher(renamed).matches()) {
            throw new ConnectException("Illegal topic name '" + renamed + "' after applying rename format to topic '" + topic + "'");
        }
        return renamed;
    }

    public static long nextDeadline(Long ... deadlines) {
        long nextDeadline = Long.MAX_VALUE;
        for (Long next : deadlines) {
            if (next == null) continue;
            nextDeadline = Math.min(nextDeadline, next);
        }
        return nextDeadline;
    }

    public static void closeQuietly(AutoCloseable closeable, String name, AtomicReference<Throwable> firstException) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                firstException.compareAndSet(null, t);
                log.error("Failed to close {} with type {}", new Object[]{name, closeable.getClass().getName(), t});
            }
        }
    }
}

