/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;

public final class GroupTopicPartition {
    private int hash = 0;
    private final int partition;
    private final String topic;
    private final String groupId;

    public GroupTopicPartition(String groupId, String topic, int partition) {
        this.partition = partition;
        this.topic = topic;
        this.groupId = groupId;
    }

    public GroupTopicPartition(String groupId, TopicPartition topicPartition) {
        this(groupId, topicPartition.topic(), topicPartition.partition());
    }

    public TopicPartition topicPartition() {
        return new TopicPartition(this.topic, this.partition);
    }

    public int partition() {
        return this.partition;
    }

    public String topic() {
        return this.topic;
    }

    public String groupId() {
        return this.groupId;
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.partition, this.topic, this.groupId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupTopicPartition other = (GroupTopicPartition)obj;
        if (this.partition != other.partition) {
            return false;
        }
        return Objects.equals(this.topic, other.topic) && Objects.equals(this.groupId, other.groupId);
    }

    public String toString() {
        return this.groupId + ": " + this.topic + "-" + this.partition;
    }
}

