/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.GroupTopicPartitionSerializer;
import io.confluent.connect.replicator.offsets.TimestampAndDeltaSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.internals.Topic;

public class ConsumerTimestampsWriterDefaults {
    public static final String CONSUMER_TIMESTAMPS_TOPIC_NAME = "__consumer_timestamps";
    private static final String ACKS_CONFIG = "all";
    private static final String COMPRESSION_TYPE_CONFIG = "lz4";
    private static final String INTERCEPTOR_CLASSES_CONFIG = "";
    private static final String KEY_SERIALIZER_CLASS_CONFIG = GroupTopicPartitionSerializer.class.getName();
    private static final String LINGER_MS_CONFIG = "500";
    private static final int MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = 1;
    private static final int DELIVERY_TIMEOUT_MS_CONFIG = Integer.MAX_VALUE;
    private static final long RETRY_BACKOFF_MS_CONFIG = 500L;
    private static final String VALUE_SERIALIZER_CLASS_CONFIG = TimestampAndDeltaSerializer.class.getName();
    public static final int MAX_REQUEST_SIZE = 0xA00000;
    public static final Map<String, Object> PRODUCER_CONFIG_DEFAULTS = ConsumerTimestampsWriterDefaults.createProducerConfigDefaults();

    private static Map<String, Object> createProducerConfigDefaults() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("acks", ACKS_CONFIG);
        configs.put("compression.type", COMPRESSION_TYPE_CONFIG);
        configs.put("key.serializer", KEY_SERIALIZER_CLASS_CONFIG);
        configs.put("value.serializer", VALUE_SERIALIZER_CLASS_CONFIG);
        configs.put("linger.ms", LINGER_MS_CONFIG);
        configs.put("delivery.timeout.ms", Integer.MAX_VALUE);
        configs.put("interceptor.classes", INTERCEPTOR_CLASSES_CONFIG);
        configs.put("retry.backoff.ms", 500L);
        configs.put("max.in.flight.requests.per.connection", 1);
        configs.put("max.request.size", 0xA00000);
        return configs;
    }

    public static boolean isInternal(String topic) {
        return Topic.isInternal((String)topic) || topic.equals(CONSUMER_TIMESTAMPS_TOPIC_NAME);
    }
}

