/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.util.RegexValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class ConsumerTimestampsWriterConfig
extends AbstractConfig {
    public static final String TIMESTAMPS_PRODUCER_PREFIX = "timestamps.producer.";
    public static final String TIMESTAMPS_TOPIC_PREFIX = "timestamps.topic.";
    public static final String TIMESTAMPS_TOPIC_NUM_PARTITIONS_CONFIG = "timestamps.topic.num.partitions";
    public static final int TIMESTAMPS_TOPIC_NUM_PARTITIONS_DEFAULT = 50;
    public static final String TIMESTAMPS_TOPIC_NUM_PARTITIONS_CONFIG_DOC = "Number of partitions for consumer timestamps topic.";
    public static final String TIMESTAMPS_TOPIC_REPLICATION_FACTOR_CONFIG = "timestamps.topic.replication.factor";
    public static final short TIMESTAMPS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String TIMESTAMPS_TOPIC_REPLICATION_FACTOR_CONFIG_DOC = "Replication factor for consumer timestamps topic.";
    public static final String MAX_TIMESTAMPS_PROCESSED_PER_PARTITION_CONFIG = "timestamps.producer.max.per.partition";
    public static final int MAX_TIMESTAMPS_PROCESSED_PER_PARTITION_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_TIMESTAMPS_PROCESSED_PER_PARTITION_CONFIG_DOC = "The maximum number of timestamp records that will be held in memory for processing per partition.  This is initially unbounded but can be configured lower to reduce memory consumption.  If the number of timestamp records exceeds this value, then timestamps could be lost, which would result in losing the corresponding translated offsets.";
    public static final String TOPIC_WHITELIST_CONFIG = "topic.whitelist";
    public static final String TOPIC_BLACKLIST_CONFIG = "topic.blacklist";
    public static final String TOPIC_REGEX_CONFIG = "topic.regex";
    public static final String TIMESTAMPS_PRODUCER_TOPIC_WHITELIST_CONFIG = "timestamps.producer.topic.whitelist";
    public static final String TIMESTAMPS_PRODUCER_TOPIC_BLACKLIST_CONFIG = "timestamps.producer.topic.blacklist";
    public static final String TIMESTAMPS_PRODUCER_TOPIC_REGEX_CONFIG = "timestamps.producer.topic.regex";
    private static final ConfigDef.Range POSITIVE_NUM_VALIDATOR = ConfigDef.Range.atLeast((Number)1);
    private static final ConfigDef config = new ConfigDef().define("timestamps.topic.num.partitions", ConfigDef.Type.INT, (Object)50, (ConfigDef.Validator)POSITIVE_NUM_VALIDATOR, ConfigDef.Importance.HIGH, "Number of partitions for consumer timestamps topic.").define("timestamps.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)POSITIVE_NUM_VALIDATOR, ConfigDef.Importance.HIGH, "Replication factor for consumer timestamps topic.").define("timestamps.producer.max.per.partition", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, "The maximum number of timestamp records that will be held in memory for processing per partition.  This is initially unbounded but can be configured lower to reduce memory consumption.  If the number of timestamp records exceeds this value, then timestamps could be lost, which would result in losing the corresponding translated offsets.").define("timestamps.producer.topic.regex", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new RegexValidator(), ConfigDef.Importance.MEDIUM, "Regex of topics for timestamp records.").define("timestamps.producer.topic.whitelist", ConfigDef.Type.LIST, null, ConfigDef.Importance.MEDIUM, "Whitelist of topics for timestamp records. A ``null`` value indicates all topics.").define("timestamps.producer.topic.blacklist", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, "Topics to exclude from timestamp records.");

    public ConsumerTimestampsWriterConfig(Map<String, ?> clientConfigs) {
        super(config, clientConfigs);
    }

    static ConsumerTimestampsWriterConfig getConfig(Map<String, ?> clientConfigs) {
        return new ConsumerTimestampsWriterConfig(clientConfigs);
    }

    public Pattern getTopicPattern() {
        String regex = this.getString(TIMESTAMPS_PRODUCER_TOPIC_REGEX_CONFIG);
        return regex == null ? null : Pattern.compile(regex);
    }

    public Set<String> getTopics() {
        List whitelist = this.getList(TIMESTAMPS_PRODUCER_TOPIC_WHITELIST_CONFIG);
        return whitelist == null ? null : new HashSet(whitelist);
    }

    public Set<String> getBlacklistTopics() {
        return new HashSet<String>(this.getList(TIMESTAMPS_PRODUCER_TOPIC_BLACKLIST_CONFIG));
    }
}

