/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.GroupTopicPartition;
import io.confluent.connect.replicator.offsets.GroupTopicPartitionDeserializer;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class GroupTopicPartitionDeserializerTest {
    @Test
    public void deserializeNullOrEmpty() {
        GroupTopicPartitionDeserializer deserializer = new GroupTopicPartitionDeserializer();
        deserializer.configure(Collections.emptyMap(), true);
        Assert.assertNull((Object)deserializer.deserialize("topic", null));
        Assert.assertNull((Object)deserializer.deserialize("topic", new byte[0]));
    }

    @Test
    public void deserialize() {
        byte[] rawBytes = new byte[]{0, 0, 0, 7, 109, 121, 103, 114, 111, 117, 112, 0, 0, 0, 3, 102, 111, 111, 0, 0, 0, 1};
        GroupTopicPartitionDeserializer deserializer = new GroupTopicPartitionDeserializer();
        deserializer.configure(Collections.emptyMap(), true);
        GroupTopicPartition groupTopicPartition = deserializer.deserialize(null, rawBytes);
        Assert.assertNotNull((Object)groupTopicPartition);
        Assert.assertEquals((Object)new GroupTopicPartition("mygroup", "foo", 1), (Object)groupTopicPartition);
    }
}

