/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.ConsumerTimestampsWriter;
import io.confluent.connect.replicator.util.NewReplicatorAdminClient;
import io.confluent.connect.replicator.util.ReplicatorAdminClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerTimestampsWriterTest {
    private ReplicatorAdminClient client;
    private AdminClient adminClient;
    private final String taskId = "replicator-1";

    @Before
    public void startup() {
        this.adminClient = (AdminClient)EasyMock.createMock(AdminClient.class);
        this.client = new NewReplicatorAdminClient(this.adminClient, (Time)new SystemTime(), 60000L, "replicator-1");
    }

    @Test
    public void shouldCreateTopicIfNotExists() throws Exception {
        DescribeTopicsResult describeTopicsResult = (DescribeTopicsResult)EasyMock.mock(DescribeTopicsResult.class);
        TopicPartitionInfo partitionInfo = (TopicPartitionInfo)EasyMock.mock(TopicPartitionInfo.class);
        Map<String, TopicDescription> topicDescriptions = Collections.singletonMap("foo", new TopicDescription("foo", false, Arrays.asList(partitionInfo)));
        HashMap<String, KafkaFuture> describeTopicsResultValue = new HashMap<String, KafkaFuture>();
        describeTopicsResultValue.put("foo", KafkaFuture.completedFuture((Object)topicDescriptions.get("foo")));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Collection.class))).andReturn((Object)describeTopicsResult).atLeastOnce();
        EasyMock.expect((Object)describeTopicsResult.values()).andReturn(describeTopicsResultValue).atLeastOnce();
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        CreateTopicsResult createTopicsResult = (CreateTopicsResult)EasyMock.mock(CreateTopicsResult.class);
        Capture topicRequest = EasyMock.newCapture();
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.capture((Capture)topicRequest))).andReturn((Object)createTopicsResult);
        EasyMock.expect((Object)createTopicsResult.all()).andReturn((Object)kafkaFuture);
        EasyMock.expect((Object)kafkaFuture.get()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeTopicsResult, createTopicsResult});
        ConsumerTimestampsWriter writer = new ConsumerTimestampsWriter(this.client);
        writer.configure(Collections.singletonMap("bootstrap.servers", "localhost:9092"));
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeTopicsResult});
    }

    @Test
    public void shouldCreateTopicWithDefaultReplicationFactorIfNotEnoughBrokers() throws Exception {
        DescribeTopicsResult describeTopicsResult = (DescribeTopicsResult)EasyMock.mock(DescribeTopicsResult.class);
        TopicPartitionInfo partitionInfo = (TopicPartitionInfo)EasyMock.mock(TopicPartitionInfo.class);
        Map<String, TopicDescription> topicDescriptions = Collections.singletonMap("foo", new TopicDescription("foo", false, Arrays.asList(partitionInfo)));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.anyObject(Collection.class))).andReturn((Object)describeTopicsResult).atLeastOnce();
        EasyMock.expect((Object)describeTopicsResult.all()).andReturn((Object)KafkaFuture.completedFuture(topicDescriptions)).atLeastOnce();
        ExecutionException expectedException = new ExecutionException((Throwable)new InvalidReplicationFactorException("Invalid replication factor"));
        KafkaFuture kafkaFuture = (KafkaFuture)EasyMock.mock(KafkaFuture.class);
        CreateTopicsResult createTopicsResult = (CreateTopicsResult)EasyMock.mock(CreateTopicsResult.class);
        Capture topicRequest = EasyMock.newCapture();
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.capture((Capture)topicRequest))).andReturn((Object)createTopicsResult);
        EasyMock.expect((Object)createTopicsResult.all()).andReturn((Object)kafkaFuture).times(2);
        EasyMock.expect((Object)kafkaFuture.get()).andThrow((Throwable)expectedException);
        Capture topicRequestDefaultReplicationFactor = EasyMock.newCapture();
        EasyMock.expect((Object)this.adminClient.createTopics((Collection)EasyMock.capture((Capture)topicRequestDefaultReplicationFactor))).andReturn((Object)createTopicsResult);
        EasyMock.expect((Object)kafkaFuture.get()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.adminClient, createTopicsResult, kafkaFuture});
        ConsumerTimestampsWriter writer = new ConsumerTimestampsWriter(this.client);
        writer.configure(Collections.singletonMap("bootstrap.servers", "localhost:9092"));
        Assert.assertTrue((boolean)((NewTopic)((Collection)topicRequestDefaultReplicationFactor.getValue()).iterator().next()).toString().contains("replicationFactor=default"));
        EasyMock.verify((Object[])new Object[]{this.adminClient});
    }

    @Test
    public void shouldNotCreateTopicIfExists() {
        TopicPartitionInfo partitionInfo = (TopicPartitionInfo)EasyMock.mock(TopicPartitionInfo.class);
        Map<String, TopicDescription> topicDescriptions = Collections.singletonMap("__consumer_timestamps", new TopicDescription("__consumer_timestamps", false, Arrays.asList(partitionInfo)));
        DescribeTopicsResult describeTopicsResult = (DescribeTopicsResult)EasyMock.mock(DescribeTopicsResult.class);
        Capture describeTopicRequest = EasyMock.newCapture();
        HashMap<String, KafkaFuture> describeTopicsResultValue = new HashMap<String, KafkaFuture>();
        describeTopicsResultValue.put("__consumer_timestamps", KafkaFuture.completedFuture((Object)topicDescriptions.get("__consumer_timestamps")));
        EasyMock.expect((Object)this.adminClient.describeTopics((Collection)EasyMock.capture((Capture)describeTopicRequest))).andReturn((Object)describeTopicsResult).atLeastOnce();
        EasyMock.expect((Object)describeTopicsResult.values()).andReturn(describeTopicsResultValue).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.adminClient, describeTopicsResult});
        ConsumerTimestampsWriter writer = new ConsumerTimestampsWriter(this.client);
        writer.configure(Collections.singletonMap("bootstrap.servers", "localhost:9092"));
        EasyMock.verify((Object[])new Object[]{this.adminClient, describeTopicsResult});
        Assert.assertEquals(Collections.singleton("__consumer_timestamps"), (Object)describeTopicRequest.getValue());
    }
}

