/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.ConsumerTimestampsInterceptor;
import io.confluent.connect.replicator.offsets.ConsumerTimestampsWriter;
import io.confluent.connect.replicator.offsets.GroupTopicPartition;
import io.confluent.connect.replicator.offsets.TimestampAndDelta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerTimestampsInterceptorTest
extends EasyMockSupport {
    @Mock
    private ConsumerTimestampsWriter writer;

    @Before
    public void startup() {
        this.writer = (ConsumerTimestampsWriter)this.createMock(ConsumerTimestampsWriter.class);
    }

    @Test
    public void testInterceptorOnConsume() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.writer.blacklistTopics()).andReturn(Collections.emptySet()).times(2);
        EasyMock.expect((Object)this.writer.whitelistTopics()).andReturn(null).times(2);
        EasyMock.expect((Object)this.writer.topicPattern()).andReturn(null).times(2);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        HashMap<TopicPartition, ArrayList<ConsumerRecord>> map = new HashMap<TopicPartition, ArrayList<ConsumerRecord>>();
        map.put(topicPartition, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)1L, (long)offsetTimestamps.size());
        Assert.assertEquals((Object)topicPartition, offsetTimestamps.keySet().iterator().next());
        Map timestampsPerPartition = (Map)offsetTimestamps.get(topicPartition);
        Assert.assertEquals((long)5L, (long)timestampsPerPartition.size());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)(i * 2), (long)((Long)timestampsPerPartition.get(i)));
        }
    }

    @Test
    public void testInterceptorOnConsumeIgnoreNoTimestamp() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.writer.blacklistTopics()).andReturn(Collections.emptySet()).times(2);
        EasyMock.expect((Object)this.writer.whitelistTopics()).andReturn(null).times(2);
        EasyMock.expect((Object)this.writer.topicPattern()).andReturn(null).times(2);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic", 1, (long)i, i == 0 ? -1L : (long)(i * 2), i == 0 ? TimestampType.NO_TIMESTAMP_TYPE : TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        HashMap<TopicPartition, ArrayList<ConsumerRecord>> map = new HashMap<TopicPartition, ArrayList<ConsumerRecord>>();
        map.put(topicPartition, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)1L, (long)offsetTimestamps.size());
        Assert.assertEquals((Object)topicPartition, offsetTimestamps.keySet().iterator().next());
        Map timestampsPerPartition = (Map)offsetTimestamps.get(topicPartition);
        Assert.assertEquals((long)4L, (long)timestampsPerPartition.size());
    }

    @Test
    public void testInterceptorOnConsumeIgnoreTopic() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("__consumer_timestamps", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("__consumer_timestamps", 1);
        HashMap<TopicPartition, ArrayList<ConsumerRecord>> map = new HashMap<TopicPartition, ArrayList<ConsumerRecord>>();
        map.put(topicPartition, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)0L, (long)offsetTimestamps.size());
    }

    @Test
    public void testInterceptorOnCommit() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.writer.blacklistTopics()).andReturn(Collections.emptySet()).times(2);
        EasyMock.expect((Object)this.writer.whitelistTopics()).andReturn(null).times(2);
        EasyMock.expect((Object)this.writer.topicPattern()).andReturn(null).times(2);
        GroupTopicPartition groupTopicPartition = new GroupTopicPartition("mygroup", "mytopic", 1);
        EasyMock.expect((Object)this.writer.send(groupTopicPartition, new TimestampAndDelta(6L))).andStubReturn(null);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        HashMap<TopicPartition, ArrayList<ConsumerRecord>> map = new HashMap<TopicPartition, ArrayList<ConsumerRecord>>();
        map.put(topicPartition, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetAndMetadata offset = new OffsetAndMetadata(4L);
        offsets.put(topicPartition, offset);
        interceptor.onCommit(offsets);
        this.verifyAll();
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)1L, (long)offsetTimestamps.size());
        Assert.assertEquals((Object)topicPartition, offsetTimestamps.keySet().iterator().next());
        Map timestampsPerPartition = (Map)offsetTimestamps.get(topicPartition);
        Assert.assertEquals((long)2L, (long)timestampsPerPartition.size());
        for (int i = 3; i < 5; ++i) {
            Assert.assertEquals((long)(i * 2), (long)((Long)timestampsPerPartition.get(i)));
        }
    }

    @Test
    public void testInterceptorOnCommitIgnoreDuplicates() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.writer.blacklistTopics()).andReturn(Collections.emptySet()).times(3);
        EasyMock.expect((Object)this.writer.whitelistTopics()).andReturn(null).times(3);
        EasyMock.expect((Object)this.writer.topicPattern()).andReturn(null).times(3);
        GroupTopicPartition groupTopicPartition = new GroupTopicPartition("mygroup", "mytopic", 1);
        EasyMock.expect((Object)this.writer.send(groupTopicPartition, new TimestampAndDelta(6L))).andReturn(null).times(1);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        HashMap<TopicPartition, ArrayList<ConsumerRecord>> map = new HashMap<TopicPartition, ArrayList<ConsumerRecord>>();
        map.put(topicPartition, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetAndMetadata offset = new OffsetAndMetadata(4L);
        offsets.put(topicPartition, offset);
        interceptor.onCommit(offsets);
        interceptor.onCommit(offsets);
        this.verifyAll();
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)1L, (long)offsetTimestamps.size());
        Assert.assertEquals((Object)topicPartition, offsetTimestamps.keySet().iterator().next());
        Map timestampsPerPartition = (Map)offsetTimestamps.get(topicPartition);
        Assert.assertEquals((long)2L, (long)timestampsPerPartition.size());
        for (int i = 3; i < 5; ++i) {
            Assert.assertEquals((long)(i * 2), (long)((Long)timestampsPerPartition.get(i)));
        }
    }

    @Test
    public void testInterceptorOnCommitIgnoreTopic() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        GroupTopicPartition groupTopicPartition = new GroupTopicPartition("mygroup", "mytopic", 1);
        EasyMock.expect((Object)this.writer.send(groupTopicPartition, new TimestampAndDelta(6L))).andStubReturn(null);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("__consumer_timestamps", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("__consumer_timestamps", 1);
        HashMap<TopicPartition, ArrayList<ConsumerRecord>> map = new HashMap<TopicPartition, ArrayList<ConsumerRecord>>();
        map.put(topicPartition, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetAndMetadata offset = new OffsetAndMetadata(4L);
        offsets.put(topicPartition, offset);
        interceptor.onCommit(offsets);
        this.verifyAll();
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)0L, (long)offsetTimestamps.size());
    }

    @Test
    public void testInterceptorWithWhitelist() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.writer.blacklistTopics()).andReturn(Collections.emptySet()).times(2);
        EasyMock.expect((Object)this.writer.whitelistTopics()).andReturn(Collections.singleton("mytopic")).times(4);
        EasyMock.expect((Object)this.writer.topicPattern()).andReturn(null).times(2);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        HashMap map = new HashMap();
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        map.put(topicPartition, records);
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic2", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition2 = new TopicPartition("mytopic2", 1);
        map.put(topicPartition2, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)1L, (long)offsetTimestamps.size());
        Assert.assertEquals((Object)topicPartition, offsetTimestamps.keySet().iterator().next());
        Map timestampsPerPartition = (Map)offsetTimestamps.get(topicPartition);
        Assert.assertEquals((long)5L, (long)timestampsPerPartition.size());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)(i * 2), (long)((Long)timestampsPerPartition.get(i)));
        }
        Map timestampsPerPartition2 = (Map)offsetTimestamps.get(topicPartition2);
        Assert.assertEquals(null, (Object)timestampsPerPartition2);
    }

    @Test
    public void testInterceptorWithBlacklist() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.writer.blacklistTopics()).andReturn(Collections.singleton("mytopic2")).times(2);
        EasyMock.expect((Object)this.writer.whitelistTopics()).andReturn(null).times(2);
        EasyMock.expect((Object)this.writer.topicPattern()).andReturn(null).times(2);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        HashMap map = new HashMap();
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        map.put(topicPartition, records);
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic2", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition2 = new TopicPartition("mytopic2", 1);
        map.put(topicPartition2, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)1L, (long)offsetTimestamps.size());
        Assert.assertEquals((Object)topicPartition, offsetTimestamps.keySet().iterator().next());
        Map timestampsPerPartition = (Map)offsetTimestamps.get(topicPartition);
        Assert.assertEquals((long)5L, (long)timestampsPerPartition.size());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)(i * 2), (long)((Long)timestampsPerPartition.get(i)));
        }
        Map timestampsPerPartition2 = (Map)offsetTimestamps.get(topicPartition2);
        Assert.assertEquals(null, (Object)timestampsPerPartition2);
    }

    @Test
    public void testInterceptorWithRegex() {
        Map<String, String> config = Collections.singletonMap("group.id", "mygroup");
        this.writer.configure(config);
        EasyMock.expectLastCall();
        Pattern regex = Pattern.compile("mytopic.*");
        EasyMock.expect((Object)this.writer.blacklistTopics()).andReturn(Collections.emptySet()).times(2);
        EasyMock.expect((Object)this.writer.whitelistTopics()).andReturn(null).times(2);
        EasyMock.expect((Object)this.writer.topicPattern()).andReturn((Object)regex).times(6);
        this.replayAll();
        ConsumerTimestampsInterceptor interceptor = new ConsumerTimestampsInterceptor(this.writer);
        interceptor.configure(config);
        HashMap map = new HashMap();
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        map.put(topicPartition, records);
        for (int i = 0; i < 5; ++i) {
            ConsumerRecord record = new ConsumerRecord("mytopic2", 1, (long)i, (long)(i * 2), TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"key", (Object)"value");
            records.add(record);
        }
        TopicPartition topicPartition2 = new TopicPartition("mytopic2", 1);
        map.put(topicPartition2, records);
        ConsumerRecords consumerRecords = new ConsumerRecords(map);
        interceptor.onConsume(consumerRecords);
        Map offsetTimestamps = interceptor.offsetTimestamps();
        Assert.assertEquals((long)2L, (long)offsetTimestamps.size());
        Assert.assertEquals((Object)topicPartition, offsetTimestamps.keySet().iterator().next());
        Map timestampsPerPartition = (Map)offsetTimestamps.get(topicPartition);
        Assert.assertEquals((long)5L, (long)timestampsPerPartition.size());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)(i * 2), (long)((Long)timestampsPerPartition.get(i)));
        }
        Map timestampsPerPartition2 = (Map)offsetTimestamps.get(topicPartition2);
        Assert.assertEquals((long)5L, (long)timestampsPerPartition2.size());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)(i * 2), (long)((Long)timestampsPerPartition2.get(i)));
        }
    }
}

