/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.offsets.ConsumerTimestampsCommitter;
import io.confluent.connect.replicator.offsets.ConsumerTimestampsWriter;
import io.confluent.connect.replicator.offsets.GroupTopicPartition;
import io.confluent.connect.replicator.offsets.TimestampAndDelta;
import io.confluent.connect.replicator.util.Utils;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.source.SourceRecord;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.easymock.IAnswer;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerTimestampsCommitterTest
extends EasyMockSupport {
    @Mock
    private ConsumerTimestampsWriter writer;

    @Before
    public void startup() {
        this.writer = (ConsumerTimestampsWriter)this.createMock(ConsumerTimestampsWriter.class);
    }

    @Test
    public void testCommitRecord() {
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        ConsumerTimestampsCommitter committer = new ConsumerTimestampsCommitter("mygroup", this.writer);
        SourceRecord sourceRecord = new SourceRecord(Utils.toConnectPartition((String)topicPartition.topic(), (int)topicPartition.partition()), null, null, null, null, null, null, null, Long.valueOf(100L), null);
        committer.commitRecord(sourceRecord);
        Map timestamps = committer.timestamps();
        Assert.assertEquals((long)1L, (long)timestamps.size());
        Assert.assertEquals((Object)topicPartition, timestamps.keySet().iterator().next());
        Assert.assertEquals((long)100L, (long)((Long)timestamps.get(topicPartition)));
    }

    @Test
    public void testCommit() {
        TopicPartition topicPartition = new TopicPartition("mytopic", 1);
        ConsumerTimestampsCommitter committer = new ConsumerTimestampsCommitter("mygroup", this.writer);
        final Capture cap = EasyMock.newCapture((CaptureType)CaptureType.FIRST);
        EasyMock.expect((Object)this.writer.send((GroupTopicPartition)EasyMock.anyObject(), (TimestampAndDelta)EasyMock.anyObject(), (Callback)EasyMock.capture((Capture)cap))).andAnswer((IAnswer)new IAnswer<Future<RecordMetadata>>(){

            public Future<RecordMetadata> answer() throws Throwable {
                ((Callback)cap.getValue()).onCompletion(null, null);
                return null;
            }
        });
        this.replayAll();
        SourceRecord sourceRecord = new SourceRecord(Utils.toConnectPartition((String)topicPartition.topic(), (int)topicPartition.partition()), null, null, null, null, null, null, null, Long.valueOf(100L), null);
        committer.commitRecord(sourceRecord);
        Map timestamps = committer.timestamps();
        Assert.assertEquals((long)1L, (long)timestamps.size());
        committer.commit();
        Assert.assertEquals((long)0L, (long)timestamps.size());
        this.verifyAll();
    }
}

