/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import io.confluent.testing.MdsTestRetryAnalyzer;
import io.confluent.testing.ldap.client.ExampleComLdapCrud;
import io.confluent.testing.ldap.client.ExampleComLdapCrudWithMemberOf;
import io.confluent.testing.ldap.server.LdapServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LdapCrudWithMemberOfTest {
    private LdapServer ldapServer;

    @BeforeMethod
    private void before() {
        this.ldapServer = LdapServer.defaultServerNoUsers().start();
    }

    @AfterMethod
    private void after() {
        if (this.ldapServer != null) {
            this.ldapServer.stop();
        }
    }

    @Test
    public void checkIfMemberOfWorks() {
        ExampleComLdapCrudWithMemberOf ldapClient = new ExampleComLdapCrudWithMemberOf(this.ldapServer.actualPort());
        List<String> users = LdapCrudWithMemberOfTest.getUserNames(10);
        users.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).createUser(arg_0));
        List<String> groups = LdapCrudWithMemberOfTest.getGroupNames(10);
        groups.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).createGroup(arg_0));
        for (String user : users) {
            for (String group : groups) {
                ldapClient.addUserToGroup(user, group);
            }
        }
        for (String user : users) {
            Assert.assertEquals((Collection)ldapClient.groupListFromUserEntry(user).stream().sorted().collect(Collectors.toList()), (Collection)ldapClient.groupsForUser(user).stream().sorted().collect(Collectors.toList()));
        }
        users.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).deleteUser(arg_0));
        groups.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).deleteGroup(arg_0));
    }

    @Test
    public void basicUserTest() {
        ExampleComLdapCrudWithMemberOf ldapClient = new ExampleComLdapCrudWithMemberOf(this.ldapServer.actualPort());
        Assert.assertTrue((boolean)ldapClient.listAllUsers().isEmpty());
        List<String> users = LdapCrudWithMemberOfTest.getUserNames(10);
        users.forEach(user -> ldapClient.createUser(user, user));
        Assert.assertEquals(users, (Collection)ldapClient.listAllUsers().stream().sorted().collect(Collectors.toList()));
        users.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).deleteUser(arg_0));
        Assert.assertTrue((boolean)ldapClient.listAllUsers().isEmpty());
    }

    @Test
    public void basicGroupTest() {
        ExampleComLdapCrudWithMemberOf ldapClient = new ExampleComLdapCrudWithMemberOf(this.ldapServer.actualPort());
        Assert.assertTrue((boolean)ldapClient.listAllGroups().isEmpty());
        List<String> groups = LdapCrudWithMemberOfTest.getGroupNames(10);
        groups.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).createGroup(arg_0));
        Assert.assertEquals(groups, (Collection)ldapClient.listAllGroups().stream().sorted().collect(Collectors.toList()));
        groups.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).deleteGroup(arg_0));
        Assert.assertTrue((boolean)ldapClient.listAllGroups().isEmpty());
    }

    @Test
    public void staticUserGroupMembershipWorks() {
        ExampleComLdapCrudWithMemberOf ldapClient = new ExampleComLdapCrudWithMemberOf(this.ldapServer.actualPort());
        int numUsers = 10;
        int numGroups = 10;
        Assert.assertTrue((boolean)ldapClient.listAllUsers().isEmpty());
        Assert.assertTrue((boolean)ldapClient.listAllGroups().isEmpty());
        List<String> users = LdapCrudWithMemberOfTest.getUserNames(10);
        users.forEach(user -> ldapClient.createUser(user, user));
        List<String> groups = LdapCrudWithMemberOfTest.getGroupNames(10);
        groups.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).createGroup(arg_0));
        for (String group : groups) {
            Assert.assertTrue((boolean)ldapClient.usersInGroup(group).isEmpty());
        }
        for (String user2 : users) {
            Assert.assertTrue((boolean)ldapClient.groupsForUser(user2).isEmpty());
        }
        for (String user2 : users) {
            for (String group : groups) {
                ldapClient.addUserToGroup(user2, group);
            }
        }
        for (String group : groups) {
            Assert.assertEquals(users, (Collection)ldapClient.usersInGroup(group).stream().sorted().collect(Collectors.toList()));
        }
        for (String user2 : users) {
            Assert.assertEquals(groups, (Collection)ldapClient.groupsForUser(user2).stream().sorted().collect(Collectors.toList()));
        }
        users.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).deleteUser(arg_0));
        groups.forEach(arg_0 -> ((ExampleComLdapCrudWithMemberOf)ldapClient).deleteGroup(arg_0));
        Assert.assertTrue((boolean)ldapClient.listAllUsers().isEmpty());
        Assert.assertTrue((boolean)ldapClient.listAllGroups().isEmpty());
    }

    @Test(retryAnalyzer=MdsTestRetryAnalyzer.class)
    public void dynamicUserGroupMembershipWorks() {
        ExampleComLdapCrudWithMemberOf ldapClient = new ExampleComLdapCrudWithMemberOf(this.ldapServer.actualPort());
        int numUserGroup = 20;
        Assert.assertTrue((boolean)ldapClient.listAllUsers().isEmpty());
        Assert.assertTrue((boolean)ldapClient.listAllGroups().isEmpty());
        List<String> users = LdapCrudWithMemberOfTest.getUserNames(20);
        List<String> groups = LdapCrudWithMemberOfTest.getGroupNames(20);
        Hashtable localMap = new Hashtable();
        ArrayList<String> createdUsers = new ArrayList<String>();
        ArrayList<String> createdGroups = new ArrayList<String>();
        for (int i = 0; i < 20; ++i) {
            String newUser = users.get(i);
            ldapClient.createUser(newUser, newUser);
            createdUsers.add(newUser);
            createdGroups.forEach(group -> ldapClient.addUserToGroup(newUser, group));
            for (String group2 : localMap.keySet()) {
                List currentUsers = (List)localMap.get(group2);
                currentUsers.add(newUser);
                localMap.put(group2, currentUsers.stream().sorted().collect(Collectors.toList()));
            }
            Awaitility.given().await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertEquals((Collection)createdUsers.stream().sorted().collect(Collectors.toList()), (Collection)ldapClient.listAllUsers().stream().sorted().collect(Collectors.toList())));
            Assert.assertEquals(localMap, this.getUserGroupMapFromLdap((ExampleComLdapCrud)ldapClient));
            String newGroup = groups.get(i);
            ldapClient.createGroup(newGroup);
            createdGroups.add(newGroup);
            createdUsers.forEach(user -> ldapClient.addUserToGroup(user, newGroup));
            localMap.put(newGroup, createdUsers.stream().sorted().collect(Collectors.toList()));
            Assert.assertEquals((Collection)createdUsers.stream().sorted().collect(Collectors.toList()), (Collection)ldapClient.listAllUsers().stream().sorted().collect(Collectors.toList()));
            Assert.assertEquals(localMap, this.getUserGroupMapFromLdap((ExampleComLdapCrud)ldapClient));
        }
        ArrayList<String> currentUsers = createdUsers;
        ArrayList<String> currentGroups = createdGroups;
        for (int i = 0; i < 20; ++i) {
            String userToDelete = users.get(i);
            ldapClient.deleteUser(userToDelete);
            currentUsers.remove(userToDelete);
            for (String group3 : localMap.keySet()) {
                List usersInGroup = (List)localMap.get(group3);
                usersInGroup.remove(userToDelete);
                localMap.put(group3, usersInGroup.stream().sorted().collect(Collectors.toList()));
            }
            Assert.assertEquals((Collection)currentUsers.stream().sorted().collect(Collectors.toList()), (Collection)ldapClient.listAllUsers().stream().sorted().collect(Collectors.toList()));
            Assert.assertEquals(localMap, this.getUserGroupMapFromLdap((ExampleComLdapCrud)ldapClient));
            String groupToDelete = groups.get(i);
            ldapClient.deleteGroup(groupToDelete);
            currentGroups.remove(groupToDelete);
            localMap.remove(groupToDelete);
            Assert.assertEquals((Collection)currentUsers.stream().sorted().collect(Collectors.toList()), (Collection)ldapClient.listAllUsers().stream().sorted().collect(Collectors.toList()));
            Awaitility.given().await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertEquals((Map)localMap, this.getUserGroupMapFromLdap((ExampleComLdapCrud)ldapClient)));
        }
        Assert.assertTrue((boolean)ldapClient.listAllUsers().isEmpty());
        Assert.assertTrue((boolean)ldapClient.listAllGroups().isEmpty());
    }

    private static List<String> getUserNames(int numUsers) {
        return Stream.iterate(0, n -> n + 1).limit(numUsers).map(i -> String.format("User-%d", i)).sorted().collect(Collectors.toList());
    }

    private static List<String> getGroupNames(int numGroups) {
        return Stream.iterate(0, n -> n + 1).limit(numGroups).map(i -> String.format("Group-%d", i)).sorted().collect(Collectors.toList());
    }

    private Map<String, List<String>> getUserGroupMapFromLdap(ExampleComLdapCrud ldapClient) {
        return ldapClient.listAllGroups().stream().collect(Collectors.toMap(Function.identity(), group -> ldapClient.usersInGroup(group).stream().sorted().collect(Collectors.toList())));
    }
}

