/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import io.confluent.testing.ldap.client.ExampleComLdapCrud;
import io.confluent.testing.ldap.server.LdapServer;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class LdapCrudTest {
    private LdapServer ldapServer;
    private ExampleComLdapCrud ldapClient;

    @BeforeClass
    public void beforeClass() {
        this.ldapServer = LdapServer.defaultSetup().start();
        this.ldapClient = new ExampleComLdapCrud(this.ldapServer.actualPort());
    }

    @AfterClass
    public void afterClass() {
        this.ldapServer.stop();
    }

    @Test
    public void testBindAuth() {
        Assert.assertTrue((boolean)this.ldapClient.authenticateUser("alice"));
        Assert.assertTrue((boolean)this.ldapClient.authenticateUser("alice", "alice"));
        Assert.assertFalse((boolean)this.ldapClient.authenticateUser("alice", "bad-password"));
    }

    @DataProvider
    public Object[][] badCrappyNames() {
        return new Object[][]{{"kafka/kafka-1.confluent.test@CONFLUENT.TEST"}, {"bad+apple"}, {"Test\\User"}, {"Test/User"}};
    }

    @DataProvider
    public Object[][] sketchyButOkNames() {
        return new Object[][]{{"Test=User"}, {"Test_User"}, {"Test..User"}, {"Test@User"}, {"bad apple"}, {"bad*apple"}, {"(Test User"}, {"Test User)"}, {"(Test User)"}, {"Confluent (Plataforma de Eventos As\u00edncronos) - Desarrollo"}};
    }

    @Test(dataProvider="badCrappyNames", expectedExceptions={RuntimeException.class})
    public void crappyNameBreakLdap(String crappyName) {
        this.ldapClient.createUser(crappyName, "password");
    }

    @Test(dataProvider="sketchyButOkNames")
    public void sketchyNamesWorkLdap(String crappyName) {
        this.ldapClient.createUser(crappyName, "password");
        this.ldapClient.authenticateUser(crappyName, "password");
    }

    @Test
    public void testListAllUsers() {
        List users = this.ldapClient.listAllUsers();
        Assert.assertTrue((boolean)users.contains("alice"));
        Assert.assertTrue((boolean)users.contains("bob"));
        Assert.assertTrue((boolean)users.contains("carol"));
    }

    @Test
    public void testFindUser() {
        Assert.assertTrue((boolean)this.ldapClient.userExists("bob"));
        Assert.assertTrue((boolean)this.ldapClient.userExists("BOB"));
    }

    @Test
    public void testAddRemoveNewUser() {
        Assert.assertFalse((boolean)this.ldapClient.authenticateUser("zoey"));
        Assert.assertFalse((boolean)this.ldapClient.userExists("zoey"));
        this.ldapClient.createUser("zoey");
        Assert.assertTrue((boolean)this.ldapClient.authenticateUser("zoey"));
        Assert.assertTrue((boolean)this.ldapClient.userExists("zoey"));
        this.ldapClient.deleteUser("zoey");
        Assert.assertFalse((boolean)this.ldapClient.authenticateUser("zoey"));
        Assert.assertFalse((boolean)this.ldapClient.userExists("zoey"));
    }

    @Test
    public void testCreateMultipleUsers() {
        this.ldapClient.createUser("multi-user1");
        this.ldapClient.createUsers(new String[]{"multi-user2", "multi-user3", "multi-user4"});
        Assert.assertTrue((boolean)this.ldapClient.userExists("multi-user1"));
        Assert.assertTrue((boolean)this.ldapClient.userExists("multi-user2"));
        Assert.assertTrue((boolean)this.ldapClient.userExists("multi-user3"));
        Assert.assertTrue((boolean)this.ldapClient.userExists("multi-user4"));
        this.ldapClient.deleteUser("multi-user1");
        this.ldapClient.deleteUser("multi-user2");
        this.ldapClient.deleteUser("multi-user3");
        this.ldapClient.deleteUser("multi-user4");
        Assert.assertFalse((boolean)this.ldapClient.userExists("multi-user1"));
        Assert.assertFalse((boolean)this.ldapClient.userExists("multi-user2"));
        Assert.assertFalse((boolean)this.ldapClient.userExists("multi-user3"));
        Assert.assertFalse((boolean)this.ldapClient.userExists("multi-user4"));
    }

    @Test
    public void testRemoveExistingUser() {
        Assert.assertTrue((boolean)this.ldapClient.authenticateUser("henry"));
        this.ldapClient.deleteUser("henry");
        Assert.assertFalse((boolean)this.ldapClient.authenticateUser("henry", "henry-password"));
        Assert.assertFalse((boolean)this.ldapClient.userExists("henry"));
        List g4Users = this.ldapClient.usersInGroup("g4");
        Assert.assertEquals((int)g4Users.size(), (int)1);
        Assert.assertTrue((boolean)g4Users.contains("george"));
        this.ldapClient.removeUserFromGroup("henry", "g4");
    }

    @Test
    public void testListAllGroups() {
        List groups = this.ldapClient.listAllGroups();
        Assert.assertTrue((boolean)groups.contains("g1"));
        Assert.assertTrue((boolean)groups.contains("g2"));
        Assert.assertTrue((boolean)groups.contains("g3"));
    }

    @Test
    public void testGroupExists() {
        Assert.assertTrue((boolean)this.ldapClient.groupExists("g2"));
    }

    @Test
    public void testAddRemoveNewGroup() {
        Assert.assertFalse((boolean)this.ldapClient.groupExists("coffee"));
        this.ldapClient.createGroup("coffee");
        Assert.assertTrue((boolean)this.ldapClient.groupExists("coffee"));
        List coffeeUsers = this.ldapClient.usersInGroup("coffee");
        Assert.assertEquals((int)0, (int)coffeeUsers.size());
        this.ldapClient.deleteGroup("coffee");
        Assert.assertFalse((boolean)this.ldapClient.groupExists("cofee"));
    }

    @Test
    public void testRemoveExistingGroup() {
        Assert.assertTrue((boolean)this.ldapClient.groupExists("g3"));
        Assert.assertEquals((int)2, (int)this.ldapClient.usersInGroup("g3").size());
        this.ldapClient.deleteGroup("g3");
        Assert.assertFalse((boolean)this.ldapClient.groupExists("g3"));
        Assert.assertEquals((int)0, (int)this.ldapClient.usersInGroup("g3").size());
    }

    @Test
    public void testRemovingAllUsersInAGroup() {
        Assert.assertTrue((boolean)this.ldapClient.authenticateUser("isabel"));
        this.ldapClient.deleteUser("isabel");
        Assert.assertTrue((boolean)this.ldapClient.authenticateUser("juliet"));
        this.ldapClient.deleteUser("juliet");
        Assert.assertTrue((boolean)this.ldapClient.groupExists("g5"));
    }

    @Test
    public void testListUserInGroup() {
        List users = this.ldapClient.usersInGroup("g1");
        Assert.assertTrue((boolean)users.contains("alice"));
        Assert.assertTrue((boolean)users.contains("bob"));
    }

    @Test
    public void testUserAndGroupInteractions() {
        this.ldapClient.createUser("user1");
        this.ldapClient.createUser("user2");
        this.ldapClient.createUser("user3");
        Assert.assertFalse((boolean)this.ldapClient.groupExists("group1"));
        this.ldapClient.addUserToGroup("user1", "group1");
        Assert.assertTrue((boolean)this.ldapClient.groupExists("group1"));
        this.ldapClient.addUserToGroup("user2", "group1");
        this.ldapClient.addUserToGroup("user3", "group1");
        List users = this.ldapClient.usersInGroup("group1");
        Assert.assertEquals((int)3, (int)users.size());
        Assert.assertTrue((boolean)users.contains("user1"));
        Assert.assertTrue((boolean)users.contains("user2"));
        Assert.assertTrue((boolean)users.contains("user3"));
        this.ldapClient.createGroup("group2");
        this.ldapClient.groupUsers("group2", new String[]{"user1", "user2"});
        users = this.ldapClient.usersInGroup("group2");
        Assert.assertEquals((int)2, (int)users.size());
        Assert.assertTrue((boolean)users.contains("user1"));
        Assert.assertTrue((boolean)users.contains("user2"));
        List userGroups = this.ldapClient.groupsForUser("user1");
        Assert.assertEquals((int)2, (int)userGroups.size());
        Assert.assertTrue((boolean)userGroups.contains("group1"));
        Assert.assertTrue((boolean)userGroups.contains("group2"));
        userGroups = this.ldapClient.groupsForUser("user2");
        Assert.assertEquals((int)2, (int)userGroups.size());
        Assert.assertTrue((boolean)userGroups.contains("group1"));
        Assert.assertTrue((boolean)userGroups.contains("group2"));
        userGroups = this.ldapClient.groupsForUser("user3");
        Assert.assertEquals((int)1, (int)userGroups.size());
        Assert.assertTrue((boolean)userGroups.contains("group1"));
        this.ldapClient.removeUserFromGroup("user2", "group1");
        Assert.assertFalse((boolean)this.ldapClient.usersInGroup("group1").contains("user2"));
        Assert.assertTrue((boolean)this.ldapClient.usersInGroup("group1").contains("user1"));
        Assert.assertTrue((boolean)this.ldapClient.usersInGroup("group2").contains("user1"));
        this.ldapClient.deleteUser("user1");
        Assert.assertFalse((boolean)this.ldapClient.usersInGroup("group1").contains("user1"));
        Assert.assertFalse((boolean)this.ldapClient.usersInGroup("group2").contains("user1"));
    }
}

