/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.cli.util;

import io.confluent.testing.ldap.cli.LdapCli;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class CliExecutionUtil {
    public static String runCli(String ... args) {
        return CliExecutionUtil.runCliTuple((String[])args).sysOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CliOutputs runCliTuple(String ... args) {
        ByteArrayOutputStream sysOut = new ByteArrayOutputStream();
        ByteArrayOutputStream sysErr = new ByteArrayOutputStream();
        InputStream ogSystemIn = System.in;
        PrintStream ogSystemOut = System.out;
        PrintStream ogSystemErr = System.err;
        CliOutputs outputs = new CliOutputs("", "");
        try {
            System.setIn(new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)));
            System.setOut(new PrintStream((OutputStream)sysOut, false, "UTF-8"));
            System.setErr(new PrintStream((OutputStream)sysErr, false, "UTF-8"));
            LdapCli.main(args);
            outputs = new CliOutputs(sysOut.toString("UTF-8"), sysErr.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace(ogSystemOut);
        }
        finally {
            System.setIn(ogSystemIn);
            System.setOut(ogSystemOut);
            System.setErr(ogSystemErr);
        }
        return outputs;
    }

    public static class LdapCliServer {
        private LdapCli ldapCli = new LdapCli();
        private String[] args;

        public LdapCliServer(String ... args) {
            this.args = args;
        }

        public void start() {
            this.ldapCli.doMain(this.args);
        }

        public void stop() {
            this.ldapCli.shutdownServer();
        }
    }

    public static class CliOutputs {
        public final String sysOut;
        public final String sysErr;

        public CliOutputs(String sysOut, String sysErr) {
            this.sysOut = sysOut;
            this.sysErr = sysErr;
        }
    }
}

