/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.cli;

import io.confluent.testing.ldap.cli.LdapCliProcessor;
import io.confluent.testing.ldap.client.LdapCrud;
import io.confluent.testing.ldap.server.LdapServer;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public class ServerCliProcessor
implements LdapCliProcessor {
    private LdapServer ldapServer;

    @Override
    public void intializeSubCommand(Subparsers subparsers) {
        Subparser serverParser = subparsers.addParser("server").description("Start the LDAP server.").defaultHelp(true);
        MutuallyExclusiveGroup group = serverParser.addMutuallyExclusiveGroup();
        group.addArgument(new String[]{"--no-users"}).help("Boot the default Ldap config, but with no users.").action((ArgumentAction)Arguments.storeTrue()).required(false);
        group.addArgument(new String[]{"--ldif"}).help("Specify your own ldif file to load.  Note if it doesn't use the example.com domainnone of the crud operations will work.").type(String.class).required(false);
    }

    @Override
    public void process(Namespace ns, LdapCrud ldapCrud) {
        String customLdif;
        LdapServer.LdapServerConfig config = new LdapServer.LdapServerConfig();
        config.port = ns.getInt("port");
        Boolean noUsers = ns.getBoolean("no_users");
        if (noUsers != null && noUsers.booleanValue()) {
            config.ldifClasspathFile = "/wedgeNoUsers.ldif";
        }
        if ((customLdif = ns.getString("ldif")) != null) {
            config.ldifFilesystemFile = customLdif;
        }
        this.ldapServer = new LdapServer(config);
        this.ldapServer.start();
        System.out.println("You can connect to the server now");
        System.out.println("URL:      ldap://" + config.bindAddress + ":" + config.port);
        System.out.println("User DN:  uid=admin,ou=system");
        System.out.println("Password: secret");
    }

    public void shutdownServer() {
        if (this.ldapServer != null) {
            this.ldapServer.stop();
        }
    }
}

