/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.server;

import java.net.URL;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.extractor.impl.ResourceMap;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySchemaPartition
extends AbstractLdifPartition {
    private static Logger LOG = LoggerFactory.getLogger(InMemorySchemaPartition.class);

    public InMemorySchemaPartition(SchemaManager schemaManager) {
        super(schemaManager);
    }

    @Override
    protected void doInit() throws InvalidNameException, Exception {
        if (this.initialized) {
            return;
        }
        LOG.debug("Initializing schema partition " + this.getId());
        this.suffixDn.apply(this.schemaManager);
        super.doInit();
        Map<String, Boolean> resMap = ResourceMap.getResources(Pattern.compile("schema[/\\Q\\\\E]ou=schema.*"));
        for (String resourcePath : new TreeSet<String>(resMap.keySet())) {
            if (!resourcePath.endsWith(".ldif")) continue;
            URL resource = DefaultSchemaLdifExtractor.getUniqueResource(resourcePath, "Schema LDIF file");
            LdifReader reader = new LdifReader(resource.openStream());
            LdifEntry ldifEntry = reader.next();
            reader.close();
            DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            if (entry.get("entryCSN") == null) {
                entry.add("entryCSN", defaultCSNFactory.newInstance().toString());
            }
            if (entry.get("entryUUID") == null) {
                entry.add("entryUUID", UUID.randomUUID().toString());
            }
            AddOperationContext addContext = new AddOperationContext(null, entry);
            super.add(addContext);
        }
    }
}

