/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public interface LdapCrud {
    default public boolean authenticateUser(String userName) {
        return this.authenticateUser(userName, userName);
    }

    public boolean authenticateUser(String var1, String var2);

    public List<String> listAllUsers();

    default public void createUser(String userName) {
        this.createUser(userName, userName);
    }

    public void createUser(String var1, String var2);

    default public void createUsers(List<String> users) {
        for (String userName : users) {
            this.createUser(userName, userName);
        }
    }

    default public void createUsers(String ... users) {
        this.createUsers(Arrays.asList(users));
    }

    public void deleteUser(String var1);

    default public boolean userExists(String inputUserName) {
        String userName = inputUserName.trim();
        return this.listAllUsers().stream().anyMatch(user -> StringUtils.equalsIgnoreCase(userName, user));
    }

    public List<String> listAllGroups();

    public void createGroup(String var1);

    default public void createGroups(List<String> groups) {
        for (String group : groups) {
            this.createGroup(group);
        }
    }

    public void deleteGroup(String var1);

    default public boolean groupExists(String inputGroupName) {
        String groupName = inputGroupName.trim();
        return this.listAllGroups().stream().anyMatch(group -> StringUtils.equalsIgnoreCase(groupName, group));
    }

    public List<String> usersInGroup(String var1);

    public void addUserToGroup(String var1, String var2);

    default public void groupUsers(String groupName, List<String> userNames) {
        for (String userName : userNames) {
            this.addUserToGroup(userName, groupName);
        }
    }

    default public void groupUsers(String groupName, String ... userNames) {
        this.groupUsers(groupName, Arrays.asList(userNames));
    }

    public void removeUserFromGroup(String var1, String var2);

    default public boolean userInGroup(String inputUserName, String inputGroupName) {
        String userName = inputUserName.trim();
        String groupName = inputGroupName.trim();
        return this.usersInGroup(groupName).stream().anyMatch(u -> StringUtils.equalsIgnoreCase(userName, u));
    }

    default public List<String> groupsForUser(String inputUserName) {
        String userName = inputUserName.trim();
        ArrayList<String> groupsForUser = new ArrayList<String>();
        for (String groupName : this.listAllGroups()) {
            List<String> users = this.usersInGroup(groupName);
            if (!users.stream().anyMatch(u -> StringUtils.equalsIgnoreCase(u, userName))) continue;
            groupsForUser.add(groupName);
        }
        return groupsForUser;
    }
}

