/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.client;

import io.confluent.testing.ldap.client.ExampleComLdapCrud;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;

public class ExampleComLdapCrudWithMemberOf
extends ExampleComLdapCrud {
    public static final String MEMBER_OF_ATTRIBUTE = "mail";

    public ExampleComLdapCrudWithMemberOf() {
    }

    public ExampleComLdapCrudWithMemberOf(int port) {
        super(port);
    }

    @Override
    public synchronized void deleteUser(String inputUserName) {
        String userName = inputUserName.trim();
        if (!this.userExists(userName)) {
            return;
        }
        List<String> groupsToCleanup = this.groupsForUser(userName);
        for (String group : groupsToCleanup) {
            this.removeUserFromGroup(userName, group);
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            adminContext.destroySubcontext(String.format("uid=%s,ou=users,dc=example,dc=com", userName));
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error removing a user.", ne);
        }
        finally {
            ExampleComLdapCrudWithMemberOf.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void deleteGroup(String inputGroupName) {
        String groupName = inputGroupName.trim();
        if (!this.groupExists(groupName)) {
            return;
        }
        List<String> usersToCleanup = this.usersInGroup(inputGroupName);
        for (String user : usersToCleanup) {
            this.removeUserFromGroup(user, inputGroupName);
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            adminContext.destroySubcontext(String.format("cn=%s,ou=groups,dc=example,dc=com", groupName));
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error removing a group.", ne);
        }
        finally {
            ExampleComLdapCrudWithMemberOf.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void addUserToGroup(String inputUserName, String inputGroupName) {
        String userName = inputUserName.trim();
        String groupName = inputGroupName.trim();
        if (!this.groupExists(groupName)) {
            this.createGroup(groupName);
        } else if (this.userInGroup(userName, groupName)) {
            return;
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            String userDn = String.format("uid=%s,ou=users,dc=example,dc=com", userName);
            String groupDn = String.format("cn=%s,ou=groups,dc=example,dc=com", groupName);
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("member", userDn))};
            adminContext.modifyAttributes(groupDn, member);
            ModificationItem[] memberOf = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(MEMBER_OF_ATTRIBUTE, inputGroupName))};
            adminContext.modifyAttributes(userDn, memberOf);
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error adding user to a group.", ne);
        }
        finally {
            ExampleComLdapCrudWithMemberOf.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void removeUserFromGroup(String inputUserName, String inputGroupName) {
        if (!this.userInGroup(inputUserName, inputGroupName)) {
            return;
        }
        String userName = inputUserName.trim();
        String groupName = inputGroupName.trim();
        LdapContext adminContext = this.getAdminContext();
        try {
            String userDn = String.format("uid=%s,ou=users,dc=example,dc=com", userName);
            String groupDn = String.format("cn=%s,ou=groups,dc=example,dc=com", groupName);
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("member", userDn))};
            adminContext.modifyAttributes(groupDn, member);
            ModificationItem[] memberOf = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(MEMBER_OF_ATTRIBUTE, inputGroupName))};
            adminContext.modifyAttributes(userDn, memberOf);
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error removing user from a group.", ne);
        }
        finally {
            ExampleComLdapCrudWithMemberOf.closeContext(adminContext);
        }
    }

    public List<?> groupListFromUserEntry(String inputUserName) {
        String userName = inputUserName.trim();
        ArrayList<Object> result = new ArrayList();
        if (!this.userExists(userName)) {
            return result;
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            String userDn = String.format("uid=%s,ou=users,dc=example,dc=com", userName);
            Attributes attrs = adminContext.getAttributes(userDn, new String[]{MEMBER_OF_ATTRIBUTE});
            result = Collections.list(attrs.get(MEMBER_OF_ATTRIBUTE).getAll());
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error fetching group list for user.", ne);
        }
        finally {
            ExampleComLdapCrudWithMemberOf.closeContext(adminContext);
        }
        return result;
    }
}

