/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.client;

import io.confluent.testing.ldap.client.LdapCrud;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class ExampleComLdapCrud
implements LdapCrud {
    private int port = 8389;
    private String hostname = "127.0.0.1";

    public ExampleComLdapCrud() {
    }

    public ExampleComLdapCrud(int port) {
        this.port = port;
    }

    public ExampleComLdapCrud(String hostname, int port) {
        this.port = port;
        this.hostname = hostname;
    }

    protected static void closeContext(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException ne) {
                throw new RuntimeException("LDAP error closing LdapContext.", ne);
            }
        }
    }

    protected LdapContext getAdminContext() {
        Properties adminProps = new Properties();
        adminProps.put("java.naming.provider.url", "ldap://" + this.hostname + ":" + this.port);
        adminProps.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        adminProps.put("java.naming.security.authentication", "simple");
        adminProps.put("java.naming.security.principal", "uid=admin,ou=system");
        adminProps.put("java.naming.security.credentials", "secret");
        try {
            return new InitialLdapContext(adminProps, null);
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error closing AdminContext", ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticateUser(String user, String password) {
        boolean bl;
        Properties env = new Properties();
        env.put("java.naming.provider.url", "ldap://" + this.hostname + ":" + this.port);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", String.format("uid=%s,ou=users,dc=example,dc=com", user));
        env.put("java.naming.security.credentials", password);
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            bl = true;
        }
        catch (NamingException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                ExampleComLdapCrud.closeContext(ctx);
                throw throwable;
            }
            ExampleComLdapCrud.closeContext(ctx);
            return bl2;
        }
        ExampleComLdapCrud.closeContext(ctx);
        return bl;
    }

    @Override
    public List<String> listAllUsers() {
        LdapContext adminContext = this.getAdminContext();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        ArrayList<String> result = new ArrayList<String>();
        try {
            NamingEnumeration<SearchResult> users = adminContext.search("ou=users,dc=example,dc=com", "(objectClass=inetOrgPerson)", controls);
            while (users.hasMore()) {
                SearchResult user = users.next();
                String userName = user.getName().substring(4);
                result.add(userName);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error listing all users.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String searchForUserFullDn(String searchUser) throws NamingException {
        Object[] filterArgs = new Object[]{searchUser};
        LdapContext adminContext = this.getAdminContext();
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(new String[]{"uid"});
        controls.setSearchScope(1);
        try {
            NamingEnumeration<SearchResult> users = adminContext.search("ou=users,dc=example,dc=com", "(&(objectClass=inetOrgPerson)(cn={0}))", filterArgs, controls);
            SearchResult result = users.next();
            if (users.hasMore()) {
                String string = null;
                return string;
            }
            String string = result.getNameInNamespace();
            return string;
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void createUser(String inputUserName, String password) {
        String userName = inputUserName.trim();
        if (this.userExists(userName)) {
            return;
        }
        LdapContext adminContext = this.getAdminContext();
        BasicAttributes entry = new BasicAttributes();
        entry.put("cn", userName);
        entry.put("sn", userName);
        entry.put("uid", userName);
        entry.put("userPassword", password);
        entry.put("objectClass", "inetOrgPerson");
        String entryDN = String.format("uid=%s,ou=users,dc=example,dc=com", userName);
        try {
            adminContext.createSubcontext(entryDN, (Attributes)entry);
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error creating a new user.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void createUsers(List<String> users) {
        HashSet<String> allExistingUsers = new HashSet<String>(this.listAllUsers());
        List usersToCreate = users.stream().map(String::trim).filter(userName -> !allExistingUsers.contains(userName)).collect(Collectors.toList());
        if (usersToCreate.isEmpty()) {
            return;
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            for (String userName2 : usersToCreate) {
                BasicAttributes entry = new BasicAttributes();
                entry.put("cn", userName2);
                entry.put("sn", userName2);
                entry.put("uid", userName2);
                entry.put("userPassword", userName2);
                entry.put("objectClass", "inetOrgPerson");
                String entryDN = String.format("uid=%s,ou=users,dc=example,dc=com", userName2);
                adminContext.createSubcontext(entryDN, (Attributes)entry);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error creating a new user.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void deleteUser(String inputUserName) {
        String userName = inputUserName.trim();
        if (!this.userExists(userName)) {
            return;
        }
        List<String> groupsToCleanup = this.groupsForUser(userName);
        LdapContext adminContext = this.getAdminContext();
        try {
            adminContext.destroySubcontext(String.format("uid=%s,ou=users,dc=example,dc=com", userName));
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error removing a user.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
        for (String group : groupsToCleanup) {
            this.removeUserFromGroup(userName, group);
        }
    }

    @Override
    public List<String> listAllGroups() {
        LdapContext adminContext = this.getAdminContext();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        ArrayList<String> result = new ArrayList<String>();
        try {
            NamingEnumeration<SearchResult> groups = adminContext.search("ou=groups,dc=example,dc=com", "(objectClass=groupOfNames)", controls);
            while (groups.hasMore()) {
                SearchResult group = groups.next();
                String groupName = group.getName().substring(3);
                result.add(groupName);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error listing all groups.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
        return result;
    }

    @Override
    public synchronized void createGroup(String inputGroupName) {
        String groupName = inputGroupName.trim();
        if (this.groupExists(groupName)) {
            return;
        }
        LdapContext adminContext = this.getAdminContext();
        BasicAttributes attributes = new BasicAttributes();
        attributes.put("objectClass", "groupOfNames");
        attributes.put("cn", groupName);
        attributes.put("member", "uid=,ou=users,dc=example,dc=com");
        String groupEntryDN = "cn=" + groupName + ",ou=groups,dc=example,dc=com";
        try {
            adminContext.createSubcontext(groupEntryDN, (Attributes)attributes);
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error creating a group.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void deleteGroup(String inputGroupName) {
        String groupName = inputGroupName.trim();
        if (!this.groupExists(groupName)) {
            return;
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            adminContext.destroySubcontext(String.format("cn=%s,ou=groups,dc=example,dc=com", groupName));
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error removing a group.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }

    @Override
    public List<String> usersInGroup(String inputGroupName) {
        String groupName = inputGroupName.trim();
        if (!this.groupExists(groupName)) {
            return Collections.emptyList();
        }
        LdapContext adminContext = this.getAdminContext();
        ArrayList<String> result = new ArrayList<String>();
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            NamingEnumeration<SearchResult> groups = adminContext.search(String.format("cn=%s,ou=groups,dc=example,dc=com", groupName), "(objectClass=groupOfNames)", controls);
            while (groups.hasMore()) {
                SearchResult group = groups.next();
                Attribute a = group.getAttributes().get("member");
                NamingEnumeration<?> ne = a.getAll();
                while (ne.hasMore()) {
                    String userName;
                    String userLine = (String)ne.next();
                    if (userLine == null || userLine.length() <= 5 || "".equals(userName = userLine.substring(4, userLine.indexOf(",")))) continue;
                    result.add(userName);
                }
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error looking up users in a group.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
        return result;
    }

    @Override
    public synchronized void addUserToGroup(String inputUserName, String inputGroupName) {
        String userName = inputUserName.trim();
        String groupName = inputGroupName.trim();
        if (!this.groupExists(groupName)) {
            this.createGroup(groupName);
        } else if (this.userInGroup(userName, groupName)) {
            return;
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            String userDn = String.format("uid=%s,ou=users,dc=example,dc=com", userName);
            String groupDn = String.format("cn=%s,ou=groups,dc=example,dc=com", groupName);
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("member", userDn))};
            adminContext.modifyAttributes(groupDn, member);
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error adding user to a group.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void groupUsers(String inputGroupName, List<String> userNames) {
        List usersToAdd;
        if (userNames.isEmpty()) {
            return;
        }
        String groupName = inputGroupName.trim();
        if (!this.groupExists(groupName)) {
            this.createGroup(groupName);
            usersToAdd = userNames.stream().map(String::trim).collect(Collectors.toList());
        } else {
            List<String> usersInGroup = this.usersInGroup(groupName);
            if (usersInGroup.isEmpty()) {
                usersToAdd = userNames.stream().map(String::trim).collect(Collectors.toList());
            } else {
                HashSet<String> usersAlreadyInGroup = new HashSet<String>(usersInGroup);
                usersToAdd = userNames.stream().map(String::trim).filter(userName -> !usersAlreadyInGroup.contains(userName)).collect(Collectors.toList());
            }
        }
        if (usersToAdd.isEmpty()) {
            return;
        }
        LdapContext adminContext = this.getAdminContext();
        try {
            for (String userName2 : usersToAdd) {
                String userDn = String.format("uid=%s,ou=users,dc=example,dc=com", userName2);
                String groupDn = String.format("cn=%s,ou=groups,dc=example,dc=com", groupName);
                ModificationItem[] member = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("member", userDn))};
                adminContext.modifyAttributes(groupDn, member);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error adding users to a group.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }

    @Override
    public synchronized void removeUserFromGroup(String inputUserName, String inputGroupName) {
        if (!this.userInGroup(inputUserName, inputGroupName)) {
            return;
        }
        String userName = inputUserName.trim();
        String groupName = inputGroupName.trim();
        LdapContext adminContext = this.getAdminContext();
        try {
            String userDn = String.format("uid=%s,ou=users,dc=example,dc=com", userName);
            String groupDn = String.format("cn=%s,ou=groups,dc=example,dc=com", groupName);
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("member", userDn))};
            adminContext.modifyAttributes(groupDn, member);
        }
        catch (NamingException ne) {
            throw new RuntimeException("LDAP error removing user from a group.", ne);
        }
        finally {
            ExampleComLdapCrud.closeContext(adminContext);
        }
    }
}

