/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.cli;

import io.confluent.testing.ldap.cli.GroupCliProcessor;
import io.confluent.testing.ldap.cli.LdapCliProcessor;
import io.confluent.testing.ldap.cli.ListGroupsCliProcessor;
import io.confluent.testing.ldap.cli.ListUsersCliProcessor;
import io.confluent.testing.ldap.cli.ServerCliProcessor;
import io.confluent.testing.ldap.cli.UserCliProcessor;
import io.confluent.testing.ldap.client.ExampleComLdapCrud;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;

public class LdapCli {
    private final Map<String, LdapCliProcessor> cliProcessorMap = new HashMap<String, LdapCliProcessor>();
    private final ServerCliProcessor serverCliProcessor = new ServerCliProcessor();

    public LdapCli() {
        this.cliProcessorMap.put("server", this.serverCliProcessor);
        this.cliProcessorMap.put("users", new ListUsersCliProcessor());
        this.cliProcessorMap.put("groups", new ListGroupsCliProcessor());
        this.cliProcessorMap.put("user", new UserCliProcessor());
        this.cliProcessorMap.put("group", new GroupCliProcessor());
    }

    public static void main(String[] args) {
        LdapCli ldapCli = new LdapCli();
        ldapCli.doMain(args);
    }

    public void doMain(String[] args) {
        Namespace ns;
        ArgumentParser parser = ArgumentParsers.newFor("simple-ldap").build();
        parser.addArgument("--port", "-p").help("Port to use.").setDefault((Object)8389).type(Integer.class).required(false);
        Subparsers subparsers = parser.addSubparsers().dest("cliSubparsers");
        for (Map.Entry<String, LdapCliProcessor> entry : this.cliProcessorMap.entrySet()) {
            entry.getValue().intializeSubCommand(subparsers);
        }
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return;
        }
        ExampleComLdapCrud ldapCrud = new ExampleComLdapCrud(ns.getInt("port"));
        String cliSubparser = ns.getString("cliSubparsers");
        LdapCliProcessor ldapProcessor = this.cliProcessorMap.get(cliSubparser);
        if (ldapProcessor != null) {
            ldapProcessor.process(ns, ldapCrud);
        }
    }

    public void shutdownServer() {
        this.serverCliProcessor.shutdownServer();
    }
}

