/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Set;
import org.apache.mina.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMutex {
    private static final Logger log = LoggerFactory.getLogger(PortMutex.class);
    private static final Set<Integer> claimed = new ConcurrentHashSet<Integer>();
    public static final PortMutex PORT_MUTEX = new PortMutex();

    private PortMutex() {
    }

    public synchronized int assignPort(int desiredPort) {
        if (desiredPort == 0) {
            return 0;
        }
        if (!claimed.contains(desiredPort)) {
            claimed.add(desiredPort);
            log.info("Claimed desired port " + desiredPort);
            return desiredPort;
        }
        int candidate = PortMutex.findUnusedPort();
        for (int retries = 10; retries > 0 && claimed.contains(candidate); --retries) {
            candidate = PortMutex.findUnusedPort();
        }
        if (claimed.contains(candidate)) {
            throw new RuntimeException("failed to find an unused port");
        }
        claimed.add(candidate);
        log.info("Claimed unused port " + candidate);
        return candidate;
    }

    public synchronized void releasePort(int releasedPort) {
        log.info("released port: " + releasedPort);
        claimed.remove(releasedPort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findUnusedPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

