/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.server;

import io.confluent.testing.ldap.DefaultPortMutex;
import io.confluent.testing.ldap.SpecificExceptionThrowerInterceptor;
import io.confluent.testing.ldap.server.InMemoryDirectoryServiceFactory;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.IOUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.partition.impl.avl.AvlPartition;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.awaitility.Awaitility;

public class LdapServer {
    public static final String DEFAULT_LDIF_FILE = "/wedge.ldif";
    public static final String DEFAULT_LDIF_FILE_NO_USERS = "/wedgeNoUsers.ldif";
    public static final String DEFAULT_IP_ADDDRES = "127.0.0.1";
    public static final int DEFAULT_PORT = 8389;
    private static final DefaultPortMutex DEFAULT_PORT_MUTEX = new DefaultPortMutex(8389);
    private static final AtomicBoolean defaultPortFree = new AtomicBoolean(true);
    private final DirectoryService directoryService;
    private final org.apache.directory.server.ldap.LdapServer ldapServer;

    public static LdapServer defaultSetup() {
        return new LdapServer(new LdapServerConfig());
    }

    public static LdapServer defaultServerNoUsers() {
        LdapServerConfig ldapServerConfig = new LdapServerConfig();
        ldapServerConfig.ldifClasspathFile = DEFAULT_LDIF_FILE_NO_USERS;
        return new LdapServer(ldapServerConfig);
    }

    public LdapServer(LdapServerConfig config) {
        int portToUse = DEFAULT_PORT_MUTEX.assignPort(config.port);
        try {
            InMemoryDirectoryServiceFactory dsFactory = new InMemoryDirectoryServiceFactory();
            String tempDirSuffix = RandomStringUtils.randomAlphabetic(10);
            dsFactory.init(tempDirSuffix);
            this.directoryService = dsFactory.getDirectoryService();
            this.directoryService.setAllowAnonymousAccess(config.allowAnonymous);
            List<Interceptor> interceptors = this.directoryService.getInterceptors();
            SpecificExceptionThrowerInterceptor specificExceptionThrowerInterceptor = new SpecificExceptionThrowerInterceptor();
            specificExceptionThrowerInterceptor.init(this.directoryService);
            interceptors.add(1, specificExceptionThrowerInterceptor);
            this.directoryService.setInterceptors(interceptors);
            if (config.ldifClasspathFile == null && config.ldifFilesystemFile == null) {
                this.importLdifFromClasspath(DEFAULT_LDIF_FILE);
            } else if (config.ldifClasspathFile != null) {
                this.importLdifFromClasspath(config.ldifClasspathFile);
            } else {
                this.importLdifFromFilesystem(config.ldifFilesystemFile);
            }
            this.ldapServer = new org.apache.directory.server.ldap.LdapServer();
            this.ldapServer.setTransports(new TcpTransport(config.bindAddress, portToUse));
            this.ldapServer.setDirectoryService(this.directoryService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public LdapServer start() {
        try {
            this.ldapServer.start();
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.directoryService::isStarted);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void stop() {
        int actualPort = this.actualPort();
        this.ldapServer.stop();
        try {
            this.directoryService.shutdown();
            DEFAULT_PORT_MUTEX.releasePort(actualPort);
        }
        catch (Exception e) {
            System.out.println("Error shutting down TestingLDAP server.\n");
            e.printStackTrace(System.out);
        }
    }

    public int actualPort() {
        int ldapPort = ((InetSocketAddress)this.ldapServer.getTransports()[0].getAcceptor().getLocalAddress()).getPort();
        return ldapPort;
    }

    private void importLdifFromClasspath(String classpathFile) throws Exception {
        this.importLdifFromReader(new LdifReader(LdapServer.class.getResourceAsStream(classpathFile)));
    }

    private void importLdifFromFilesystem(String ldifFile) throws Exception {
        System.out.println("Importing " + ldifFile + "\n");
        this.importLdifFromReader(new LdifReader(ldifFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importLdifFromReader(LdifReader ldifReader) throws Exception {
        try {
            for (LdifEntry ldifEntry : ldifReader) {
                this.checkPartition(ldifEntry);
                this.directoryService.getAdminSession().add(new DefaultEntry(this.directoryService.getSchemaManager(), ldifEntry.getEntry()));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)ldifReader);
        }
    }

    private void checkPartition(LdifEntry ldifEntry) throws Exception {
        Dn dn = ldifEntry.getDn();
        Dn parent = dn.getParent();
        try {
            this.directoryService.getAdminSession().exists(parent);
        }
        catch (Exception e) {
            AvlPartition partition = new AvlPartition(this.directoryService.getSchemaManager());
            partition.setId(dn.getName());
            partition.setSuffixDn(dn);
            this.directoryService.addPartition(partition);
        }
    }

    public static class LdapServerConfig {
        public String ldifClasspathFile;
        public String ldifFilesystemFile;
        public boolean allowAnonymous = false;
        public String bindAddress = "127.0.0.1";
        public int port = 8389;
    }
}

