/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.server;

import io.confluent.testing.ldap.server.InMemorySchemaPartition;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.comparators.NormalizingComparator;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.schema.loader.JarLdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.api.util.exception.Exceptions;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.factory.AvlPartitionFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDirectoryServiceFactory
implements DirectoryServiceFactory {
    private static Logger LOG = LoggerFactory.getLogger(InMemoryDirectoryServiceFactory.class);
    private final DirectoryService directoryService;
    private final PartitionFactory partitionFactory;

    public InMemoryDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.directoryService.setShutdownHookEnabled(false);
        this.partitionFactory = new AvlPartitionFactory();
    }

    @Override
    public void init(String name) throws Exception {
        if (this.directoryService.isStarted()) {
            return;
        }
        this.directoryService.setInstanceId(name);
        InstanceLayout instanceLayout = new InstanceLayout(System.getProperty("java.io.tmpdir") + "/server-work-" + name);
        if (instanceLayout.getInstanceDirectory().exists()) {
            try {
                FileUtils.deleteDirectory(instanceLayout.getInstanceDirectory());
            }
            catch (IOException e) {
                LOG.warn("couldn't delete the instance directory before initializing the DirectoryService", e);
            }
        }
        this.directoryService.setInstanceLayout(instanceLayout);
        Configuration ehCacheConfig = new Configuration();
        String cacheName = RandomStringUtils.randomAlphabetic(20);
        ehCacheConfig.setName(cacheName);
        CacheConfiguration defaultCache = new CacheConfiguration("default", 1).eternal(false).timeToIdleSeconds(30L).timeToLiveSeconds(30L).overflowToDisk(false);
        ehCacheConfig.addDefaultCache(defaultCache);
        CacheService cacheService = new CacheService(new CacheManager(ehCacheConfig));
        this.directoryService.setCacheService(cacheService);
        JarLdifSchemaLoader loader = new JarLdifSchemaLoader();
        DefaultSchemaManager schemaManager = new DefaultSchemaManager(loader);
        schemaManager.load("system", "core", "inetorgperson", "cosine", "apache", "apachemeta", "pwdpolicy");
        ComparatorRegistry comparatorRegistry = schemaManager.getComparatorRegistry();
        for (LdapComparator comparator : comparatorRegistry) {
            if (!(comparator instanceof NormalizingComparator)) continue;
            ((NormalizingComparator)comparator).setOnServer();
        }
        this.directoryService.setSchemaManager(schemaManager);
        InMemorySchemaPartition inMemorySchemaPartition = new InMemorySchemaPartition(schemaManager);
        SchemaPartition schemaPartition = new SchemaPartition(schemaManager);
        schemaPartition.setWrappedPartition(inMemorySchemaPartition);
        this.directoryService.setSchemaPartition(schemaPartition);
        List<Throwable> errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err(I18n.ERR_317, Exceptions.printErrors(errors)));
        }
        Partition systemPartition = this.partitionFactory.createPartition(this.directoryService.getSchemaManager(), this.directoryService.getDnFactory(), "system", "ou=system", 500, new File(this.directoryService.getInstanceLayout().getPartitionsDirectory(), "system"));
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        this.partitionFactory.addIndex(systemPartition, "objectClass", 100);
        this.directoryService.setSystemPartition(systemPartition);
        this.directoryService.startup();
    }

    @Override
    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public PartitionFactory getPartitionFactory() {
        return this.partitionFactory;
    }
}

