/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.cli;

import io.confluent.testing.ldap.cli.LdapCliProcessor;
import io.confluent.testing.ldap.client.LdapCrud;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.commons.lang.StringUtils;

public class UserCliProcessor
implements LdapCliProcessor {
    @Override
    public void intializeSubCommand(Subparsers subparsers) {
        Subparser userParser = subparsers.addParser("user").description("User focused operations.").defaultHelp(true);
        userParser.addArgument("USER").type(String.class).required(true);
        Subparsers subUserParsers = userParser.addSubparsers().dest("subUserParsers");
        subUserParsers.addParser(UserOperation.exists.toString()).description("Exists.").defaultHelp(true);
        subUserParsers.addParser(UserOperation.groups.toString()).description("List groups.").defaultHelp(true);
        Subparser create = subUserParsers.addParser(UserOperation.authenticate.toString()).description("Authenticate a user.").defaultHelp(true);
        create.addArgument("--password").type(String.class).help("optional password for user").required(false);
        create = subUserParsers.addParser(UserOperation.create.toString()).description("Create user.").defaultHelp(true);
        create.addArgument("--password").type(String.class).help("optional password for user").required(false);
        subUserParsers.addParser(UserOperation.delete.toString()).description("Delete user.").defaultHelp(true);
    }

    @Override
    public void process(Namespace ns, LdapCrud ldapCrud) {
        String userName = ns.getString("USER");
        String password = ns.getString("password");
        UserOperation userOperation = UserOperation.valueOf(ns.getString("subUserParsers"));
        if (StringUtils.isBlank(password)) {
            password = userName;
        }
        switch (userOperation) {
            case exists: {
                System.out.println(ldapCrud.userExists(userName));
                break;
            }
            case groups: {
                ldapCrud.groupsForUser(userName).stream().sorted().forEach(System.out::println);
                break;
            }
            case create: {
                if (ldapCrud.userExists(userName)) {
                    System.err.println(String.format("User %s already exists", userName));
                    break;
                }
                ldapCrud.createUser(userName, password);
                System.out.println(String.format("Created user %s with password %s", userName, password));
                break;
            }
            case authenticate: {
                boolean authenticated = ldapCrud.authenticateUser(userName, password);
                if (authenticated) {
                    System.out.println(String.format("Authenticated user %s with password %s", userName, password));
                    break;
                }
                System.out.println(String.format("Failed to authenticate user %s with password %s", userName, password));
                break;
            }
            case delete: {
                ldapCrud.deleteUser(userName);
                System.out.println(String.format("Deleted user %s", userName));
                break;
            }
        }
    }

    public static enum UserOperation {
        exists,
        authenticate,
        groups,
        create,
        delete;

    }
}

