/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap.cli;

import io.confluent.testing.ldap.cli.LdapCliProcessor;
import io.confluent.testing.ldap.client.LdapCrud;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public class GroupCliProcessor
implements LdapCliProcessor {
    @Override
    public void intializeSubCommand(Subparsers subparsers) {
        Subparser groupParser = subparsers.addParser("group").description("Group focused operations.").defaultHelp(true);
        groupParser.addArgument("GROUP").type(String.class).required(true);
        Subparsers subGroupParsers = groupParser.addSubparsers().dest("subGroupParsers");
        subGroupParsers.addParser(GroupOperation.exists.toString()).description("Exists.").defaultHelp(true);
        subGroupParsers.addParser(GroupOperation.users.toString()).description("List users.").defaultHelp(true);
        subGroupParsers.addParser(GroupOperation.create.toString()).description("Create group.").defaultHelp(true);
        subGroupParsers.addParser(GroupOperation.delete.toString()).description("Delete group.").defaultHelp(true);
        Subparser addParser = subGroupParsers.addParser(GroupOperation.add.toString()).description("Add user to group.").defaultHelp(true);
        addParser.addArgument("USER").type(String.class).help("user to add to group").required(true);
        Subparser deleteParser = subGroupParsers.addParser(GroupOperation.remove.toString()).description("Remove user from group.").defaultHelp(true);
        deleteParser.addArgument("USER").type(String.class).help("user to remove from group").required(true);
    }

    @Override
    public void process(Namespace ns, LdapCrud ldapCrud) {
        String groupName = ns.getString("GROUP");
        String userName = ns.getString("USER");
        GroupOperation groupOperation = GroupOperation.valueOf(ns.getString("subGroupParsers"));
        switch (groupOperation) {
            case exists: {
                System.out.println(ldapCrud.groupExists(groupName));
                break;
            }
            case users: {
                ldapCrud.usersInGroup(groupName).stream().sorted().forEach(System.out::println);
                break;
            }
            case create: {
                if (ldapCrud.groupExists(groupName)) {
                    System.err.println(String.format("Group %s already exists", groupName));
                    break;
                }
                ldapCrud.createGroup(groupName);
                System.out.println(String.format("Created group %s", groupName));
                break;
            }
            case delete: {
                ldapCrud.deleteGroup(groupName);
                System.out.println(String.format("Deleted group %s", groupName));
                break;
            }
            case add: {
                ldapCrud.addUserToGroup(userName, groupName);
                System.out.println(String.format("Added user %s to group %s", userName, groupName));
                break;
            }
            case remove: {
                ldapCrud.removeUserFromGroup(userName, groupName);
                System.out.println(String.format("Removed user %s from group %s", userName, groupName));
                break;
            }
        }
    }

    public static enum GroupOperation {
        exists,
        users,
        create,
        delete,
        add,
        remove;

    }
}

