/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.CommunicationException;
import org.apache.directory.api.ldap.model.cursor.CursorClosedException;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;

public class SpecificExceptionThrowerInterceptor
extends BaseInterceptor {
    private final Set<String> failOnceUsersSeen = new HashSet<String>();
    private static final String LDAP_CLOSED_MSG = "LDAP connection has been closed";
    private static final String LDAP_TIMEOUT_MSG = "LDAP response read timed out, timeout used";

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        String filterString = searchContext.getFilter().toString();
        if (filterString.contains("user-kaboom")) {
            ExceptionType et = ExceptionType.lookup(filterString);
            throw (LdapException)et.makeException();
        }
        if (filterString.contains("user-fail-once") && !this.failOnceUsersSeen.contains(filterString)) {
            this.failOnceUsersSeen.add(filterString);
            ExceptionType et = ExceptionType.lookup(filterString);
            return new CommunicationExceptionCursor(et);
        }
        Interceptor interceptor = this.getNextInterceptor(searchContext);
        return interceptor.search(searchContext);
    }

    private static final class CommunicationExceptionCursor
    extends EmptyCursor<Entry>
    implements EntryFilteringCursor {
        private final ExceptionType et;

        public CommunicationExceptionCursor(ExceptionType et) {
            this.et = et;
        }

        @Override
        public boolean addEntryFilter(EntryFilter filter) {
            return false;
        }

        @Override
        public List<EntryFilter> getEntryFilters() {
            return null;
        }

        @Override
        public SearchOperationContext getOperationContext() {
            return null;
        }

        @Override
        public boolean next() throws LdapException, CursorException {
            Exception e = this.et.makeException();
            if (e instanceof CursorException) {
                throw (CursorException)e;
            }
            throw (LdapException)e;
        }
    }

    public static enum ExceptionType {
        communication{

            @Override
            public Exception makeException() {
                return new CursorClosedException("BadCursor", new CommunicationException("Triggered CommunicationException"));
            }
        }
        ,
        naming_generic{

            @Override
            public Exception makeException() {
                return new LdapOperationErrorException("Generic NamingException");
            }
        }
        ,
        schema{

            @Override
            public Exception makeException() {
                return new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, "Schema Exception");
            }
        }
        ,
        naming_closed{

            @Override
            public Exception makeException() {
                return new LdapOperationErrorException(SpecificExceptionThrowerInterceptor.LDAP_CLOSED_MSG);
            }
        }
        ,
        naming_timeout{

            @Override
            public Exception makeException() {
                return new LdapOperationErrorException(SpecificExceptionThrowerInterceptor.LDAP_TIMEOUT_MSG);
            }
        };

        private static final Set<String> names;

        public static ExceptionType lookup(String potentialName) {
            String[] splits;
            for (String split : splits = potentialName.split("-")) {
                if (!names.contains(split)) continue;
                return ExceptionType.valueOf(split);
            }
            throw new RuntimeException("Should have found exception name to throw from potentialName " + potentialName);
        }

        public Exception makeException() {
            return null;
        }

        static {
            names = ((Stream)Arrays.stream(ExceptionType.values()).sequential()).map(Enum::name).collect(Collectors.toSet());
        }
    }
}

