/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import java.io.IOException;
import java.net.ServerSocket;

public class DefaultPortMutex {
    private final int defaultPort;
    private boolean portIsFree = true;

    public DefaultPortMutex(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public synchronized int assignPort(int desiredPort) {
        if (desiredPort == 0) {
            return 0;
        }
        if (desiredPort != this.defaultPort) {
            return desiredPort;
        }
        if (this.portIsFree) {
            this.portIsFree = false;
            return this.defaultPort;
        }
        return DefaultPortMutex.findUnusedPort();
    }

    public synchronized boolean releasePort(int releasedPort) {
        if (releasedPort != this.defaultPort) {
            return false;
        }
        if (!this.portIsFree) {
            this.portIsFree = true;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findUnusedPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

