/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import io.confluent.testing.ldap.cli.util.CliExecutionUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CliRemoveTest {
    private CliExecutionUtil.LdapCliServer ldapCliServer;

    @BeforeMethod
    public void setup() {
        this.ldapCliServer = new CliExecutionUtil.LdapCliServer(new String[]{"server"});
        this.ldapCliServer.start();
    }

    @AfterMethod
    public void tearDown() {
        this.ldapCliServer.stop();
    }

    @Test
    public void removeUsers() throws Exception {
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"users"}), (Matcher)CoreMatchers.is((Object)"alice\nbob\ncarol\ndave\nemily\nflowserviceadmin\nfrank\ngeorge\nhenry\nisabel\njuliet\n"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"user", "isabel", "delete"}), (Matcher)CoreMatchers.containsString((String)"Deleted user"));
        CliExecutionUtil.runCli((String[])new String[]{"user", "juliet", "delete"});
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"users"}), (Matcher)CoreMatchers.is((Object)"alice\nbob\ncarol\ndave\nemily\nflowserviceadmin\nfrank\ngeorge\nhenry\n"));
    }

    @Test
    public void removeGroups() throws Exception {
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"groups"}), (Matcher)CoreMatchers.is((Object)"g1\ng2\ng3\ng4\ng5\n"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "g4", "delete"}), (Matcher)CoreMatchers.containsString((String)"Deleted group"));
        CliExecutionUtil.runCli((String[])new String[]{"group", "g5", "delete"});
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"groups"}), (Matcher)CoreMatchers.is((Object)"g1\ng2\ng3\n"));
    }

    @Test
    public void removeUsersFromGroup() throws Exception {
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "g1", "users"}), (Matcher)CoreMatchers.is((Object)"alice\nbob\n"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "g1", "remove", "alice"}), (Matcher)CoreMatchers.containsString((String)"Removed user"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "g1", "users"}), (Matcher)CoreMatchers.is((Object)"bob\n"));
        CliExecutionUtil.runCli((String[])new String[]{"group", "g1", "remove", "bob"});
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "g1", "users"}), (Matcher)CoreMatchers.is((Object)""));
    }
}

