/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import io.confluent.testing.ldap.cli.util.CliExecutionUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CliListTest {
    private static CliExecutionUtil.LdapCliServer ldapCliServer = new CliExecutionUtil.LdapCliServer(new String[]{"server"});

    @BeforeClass
    public static void beforeClass() {
        ldapCliServer.start();
    }

    @AfterClass
    public static void afterClass() {
        ldapCliServer.stop();
    }

    @DataProvider
    public static Object[][] listTests() {
        return new Object[][]{{new String[]{"groups"}, "g1\ng2\ng3\ng4\ng5\n"}, {new String[]{"users"}, "alice\nbob\ncarol\ndave\nemily\nflowserviceadmin\nfrank\ngeorge\nhenry\nisabel\njuliet\n"}, {new String[]{"user", "alice", "exists"}, "true\n"}, {new String[]{"user", "zoey", "exists"}, "false\n"}, {new String[]{"user", "alice", "groups"}, "g1\n"}, {new String[]{"group", "g1", "users"}, "alice\nbob\n"}};
    }

    @Test(dataProvider="listTests")
    public void listTests(String[] args, String expected) throws Exception {
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])args), (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testUserAuthentication() {
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"user", "alice", "authenticate"}), (Matcher)CoreMatchers.containsString((String)"Authenticated"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"user", "alice", "authenticate", "--password", "alice"}), (Matcher)CoreMatchers.containsString((String)"Authenticated"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"user", "alice", "authenticate", "--password", "PANTS"}), (Matcher)CoreMatchers.containsString((String)"Failed"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"user", "casper", "authenticate"}), (Matcher)CoreMatchers.containsString((String)"Failed to authenticate"));
    }
}

