/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import io.confluent.testing.ldap.cli.util.CliExecutionUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CliErrorsTest {
    private static CliExecutionUtil.LdapCliServer ldapCliServer = new CliExecutionUtil.LdapCliServer(new String[]{"server"});

    @BeforeClass
    public static void beforeClass() {
        ldapCliServer.start();
    }

    @AfterClass
    public static void afterClass() {
        ldapCliServer.stop();
    }

    @DataProvider
    public static Object[][] invalidArgLines() {
        return new Object[][]{{new String[]{"group", "W", "add"}}, {new String[]{"group", "W", "remove"}}};
    }

    @Test(dataProvider="invalidArgLines")
    public void tooFewArgsTest(String[] args) throws Exception {
        CliExecutionUtil.CliOutputs outs = CliExecutionUtil.runCliTuple((String[])args);
        MatcherAssert.assertThat((Object)outs.sysOut, (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)outs.sysErr, (Matcher)CoreMatchers.containsString((String)"too few arguments"));
    }

    @DataProvider
    public static Object[][] existingEntries() {
        return new Object[][]{{new String[]{"user", "alice", "create"}, "already exists"}, {new String[]{"group", "g1", "create"}, "already exists"}};
    }

    @Test(dataProvider="existingEntries")
    public void alreadyExistsErrorsTest(String[] args, String expectedErr) throws Exception {
        CliExecutionUtil.CliOutputs outs = CliExecutionUtil.runCliTuple((String[])args);
        MatcherAssert.assertThat((Object)outs.sysOut, (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)outs.sysErr, (Matcher)CoreMatchers.containsString((String)expectedErr));
    }
}

