/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.testing.ldap;

import io.confluent.testing.ldap.cli.util.CliExecutionUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CliAddTest {
    private static CliExecutionUtil.LdapCliServer ldapCliServer = new CliExecutionUtil.LdapCliServer(new String[]{"server", "--no-users"});

    @BeforeClass
    public static void beforeClass() {
        ldapCliServer.start();
    }

    @AfterClass
    public static void afterClass() {
        ldapCliServer.stop();
    }

    @Test
    public void addTest() throws Exception {
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"users"}), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"groups"}), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"user", "wendy", "create"}), (Matcher)CoreMatchers.containsString((String)"Created user"));
        CliExecutionUtil.runCli((String[])new String[]{"user", "xyph", "create"});
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"users"}).toString(), (Matcher)CoreMatchers.is((Object)"wendy\nxyph\n"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "W", "add", "wendy"}), (Matcher)CoreMatchers.containsString((String)"Added user"));
        CliExecutionUtil.runCli((String[])new String[]{"group", "X", "add", "xyph"});
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "Z", "create"}), (Matcher)CoreMatchers.containsString((String)"Created group"));
        CliExecutionUtil.runCli((String[])new String[]{"group", "BOTH", "add", "wendy"});
        CliExecutionUtil.runCli((String[])new String[]{"group", "BOTH", "add", "xyph"});
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"groups"}), (Matcher)CoreMatchers.is((Object)"BOTH\nW\nX\nZ\n"));
        MatcherAssert.assertThat((Object)CliExecutionUtil.runCli((String[])new String[]{"group", "BOTH", "users"}), (Matcher)CoreMatchers.is((Object)"wendy\nxyph\n"));
    }
}

