/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.validate;

import io.confluent.support.metrics.validate.MetricsValidation;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MetricsValidationTest {
    @Test
    public void testValidKsqlDeploymentMode() {
        List<String> validDeploymentModes = Arrays.asList("LOCAL_CLI", "REMOTE_CLI", "SERVER", "EMBEDDED", "CLI");
        for (String mode : validDeploymentModes) {
            Assert.assertTrue((String)("Expected KSQL deployment mode '" + mode + "' to be valid"), (boolean)MetricsValidation.isValidKsqlModuleType((String)mode));
        }
    }

    @Test
    public void testInvalidKsqlDeploymentMode() {
        List<String> invalidDeploymentModes = Arrays.asList("local_CLI", "REMOTECLI", "servER", "random", "ANOTHER_CLI");
        for (String mode : invalidDeploymentModes) {
            Assert.assertFalse((String)("Expected KSQL deployment mode '" + mode + "' to be invalid"), (boolean)MetricsValidation.isValidKsqlModuleType((String)mode));
        }
    }
}

