/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.utils;

import io.confluent.support.metrics.utils.CustomerIdExamples;
import io.confluent.support.metrics.utils.WebClient;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.http.client.methods.HttpPost;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class WebClientTest {
    private String customerId = CustomerIdExamples.VALID_CUSTOMER_IDS[0];
    private static final String SECURE_LIVE_TEST_ENDPOINT = "https://support-metrics.confluent.io/test";

    @Test
    public void testSubmitIgnoresNullInput() {
        HttpPost p = (HttpPost)Mockito.mock(HttpPost.class);
        byte[] nullData = null;
        WebClient.send((String)this.customerId, nullData, (HttpPost)p, null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{p});
    }

    @Test
    public void testSubmitIgnoresEmptyInput() {
        HttpPost p = (HttpPost)Mockito.mock(HttpPost.class);
        byte[] emptyData = new byte[]{};
        WebClient.send((String)this.customerId, (byte[])emptyData, (HttpPost)p, null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{p});
    }

    @Test
    public void testSubmitInvalidCustomer() {
        HttpPost p = new HttpPost(SECURE_LIVE_TEST_ENDPOINT);
        byte[] anyData = "anyData".getBytes();
        int randomIndex = ThreadLocalRandom.current().nextInt(CustomerIdExamples.INVALID_CUSTOMER_IDS.length);
        String invalidCustomerId = CustomerIdExamples.INVALID_CUSTOMER_IDS[randomIndex];
        Assert.assertNotEquals((String)("customerId=" + invalidCustomerId), (long)200L, (long)WebClient.send((String)invalidCustomerId, (byte[])anyData, (HttpPost)p, null));
    }

    @Test
    public void testSubmitInvalidAnonymousUser() {
        HttpPost p = new HttpPost(SECURE_LIVE_TEST_ENDPOINT);
        byte[] anyData = "anyData".getBytes();
        int randomIndex = ThreadLocalRandom.current().nextInt(CustomerIdExamples.INVALID_ANONYMOUS_IDS.length);
        String invalidCustomerId = CustomerIdExamples.INVALID_ANONYMOUS_IDS[randomIndex];
        Assert.assertNotEquals((String)("customerId=" + invalidCustomerId), (long)200L, (long)WebClient.send((String)invalidCustomerId, (byte[])anyData, (HttpPost)p, null));
    }

    @Test
    public void testSubmitValidCustomer() {
        HttpPost p = new HttpPost(SECURE_LIVE_TEST_ENDPOINT);
        byte[] anyData = "anyData".getBytes();
        int randomIndex = ThreadLocalRandom.current().nextInt(CustomerIdExamples.VALID_CUSTOMER_IDS.length);
        String validCustomerId = CustomerIdExamples.VALID_CUSTOMER_IDS[randomIndex];
        int status = WebClient.send((String)validCustomerId, (byte[])anyData, (HttpPost)p, null);
        Assert.assertTrue((String)("customerId=" + validCustomerId), (status == 200 || status == 502 ? 1 : 0) != 0);
    }

    @Test
    public void testSubmitValidAnonymousUser() {
        HttpPost p = new HttpPost(SECURE_LIVE_TEST_ENDPOINT);
        byte[] anyData = "anyData".getBytes();
        int randomIndex = ThreadLocalRandom.current().nextInt(CustomerIdExamples.VALID_ANONYMOUS_IDS.length);
        String validCustomerId = CustomerIdExamples.VALID_ANONYMOUS_IDS[randomIndex];
        int status = WebClient.send((String)validCustomerId, (byte[])anyData, (HttpPost)p, null);
        Assert.assertTrue((String)("customerId=" + validCustomerId), (status == 200 || status == 502 ? 1 : 0) != 0);
    }
}

